/*
 * Decompiled with CFR 0.152.
 */
package tachiyomi.core.http;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import tachiyomi.core.http.RateBucket;
import tachiyomi.core.http.RateBucketPreferences;
import tachiyomi.core.http.RatelimitException;
import tachiyomi.core.prefs.Preference;
import tachiyomi.core.prefs.PreferenceStore;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ltachiyomi/core/http/RatelimitInterceptor;", "Lokhttp3/Interceptor;", "id", "", "capacity", "", "refillRate", "", "prefStore", "Ltachiyomi/core/prefs/PreferenceStore;", "(Ljava/lang/String;IJLtachiyomi/core/prefs/PreferenceStore;)V", "getId", "()Ljava/lang/String;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "common"})
public final class RatelimitInterceptor
implements Interceptor {
    @NotNull
    private final String id;
    private final int capacity;
    private final long refillRate;
    private final PreferenceStore prefStore;

    @NotNull
    public synchronized Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        RateBucketPreferences preferences = new RateBucketPreferences(this.prefStore);
        Preference<RateBucket> prefBucket = preferences.getBucket(this.id, this.capacity, this.refillRate);
        RateBucket rateBucket = prefBucket.get();
        if (rateBucket.getCapacity$common() != this.capacity || rateBucket.getRefillRate$common() != this.refillRate) {
            rateBucket.setCapacity$common(this.capacity);
            rateBucket.setRefillRate$common(this.refillRate);
        }
        if (rateBucket.tryConsume()) {
            prefBucket.set(rateBucket);
            return chain.call().execute();
        }
        prefBucket.set(rateBucket);
        chain.call().cancel();
        throw (Throwable)new RatelimitException("Currently ratelimited for " + this.id + '!');
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public RatelimitInterceptor(@NotNull String id, int capacity, long refillRate, @NotNull PreferenceStore prefStore) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)prefStore, (String)"prefStore");
        this.id = id;
        this.capacity = capacity;
        this.refillRate = refillRate;
        this.prefStore = prefStore;
    }
}

