/*
 * Decompiled with CFR 0.152.
 */
package tachiyomi.core.http;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import tachiyomi.core.http.CloudflareInterceptor;
import tachiyomi.core.http.CookieManager;
import tachiyomi.core.http.JSFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ltachiyomi/core/http/Http;", "", "cache", "Lokhttp3/Cache;", "cookieManager", "Ltachiyomi/core/http/CookieManager;", "jsFactory", "Ltachiyomi/core/http/JSFactory;", "(Lokhttp3/Cache;Ltachiyomi/core/http/CookieManager;Ltachiyomi/core/http/JSFactory;)V", "cloudflareClient", "Lokhttp3/OkHttpClient;", "getCloudflareClient", "()Lokhttp3/OkHttpClient;", "defaultClient", "getDefaultClient", "noStore", "Lokhttp3/CacheControl;", "getNoStore", "()Lokhttp3/CacheControl;", "common"})
public final class Http {
    @NotNull
    private final OkHttpClient defaultClient;
    @NotNull
    private final OkHttpClient cloudflareClient;
    @NotNull
    private final CacheControl noStore;

    @NotNull
    public final OkHttpClient getDefaultClient() {
        return this.defaultClient;
    }

    @NotNull
    public final OkHttpClient getCloudflareClient() {
        return this.cloudflareClient;
    }

    @NotNull
    public final CacheControl getNoStore() {
        return this.noStore;
    }

    public Http(@NotNull Cache cache, @NotNull CookieManager cookieManager, @NotNull JSFactory jsFactory) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)cookieManager, (String)"cookieManager");
        Intrinsics.checkNotNullParameter((Object)jsFactory, (String)"jsFactory");
        this.defaultClient = new OkHttpClient.Builder().cookieJar((CookieJar)cookieManager).cache(cache).build();
        this.cloudflareClient = this.defaultClient.newBuilder().addInterceptor((Interceptor)new CloudflareInterceptor(jsFactory)).build();
        this.noStore = new CacheControl.Builder().noStore().build();
    }
}

