/*
 * Decompiled with CFR 0.152.
 */
package tachiyomi.core.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import tachiyomi.core.http.CookieManager;
import tachiyomi.core.http.CookieStore;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\tH\u0002R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltachiyomi/core/http/CookieManager;", "Lokhttp3/CookieJar;", "store", "Ltachiyomi/core/http/CookieStore;", "(Ltachiyomi/core/http/CookieStore;)V", "cache", "Ljava/util/HashMap;", "", "", "Lokhttp3/Cookie;", "Lkotlin/collections/HashMap;", "clear", "", "loadForRequest", "url", "Lokhttp3/HttpUrl;", "saveFromResponse", "cookies", "hasExpired", "", "common"})
public final class CookieManager
implements CookieJar {
    private final HashMap<String, List<Cookie>> cache;
    private final CookieStore store;

    public synchronized void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        String domain = url.host();
        List list = this.cache.get(domain);
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List cookiesForDomain = CollectionsKt.toMutableList((Collection)list2);
        for (Cookie cookie : cookies) {
            int pos;
            block5: {
                int n;
                List $this$indexOfFirst$iv = cookiesForDomain;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    Cookie it = (Cookie)item$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.name(), (Object)cookie.name())) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = pos = -1;
            }
            if (pos == -1) {
                cookiesForDomain.add(cookie);
                continue;
            }
            cookiesForDomain.set(pos, cookie);
        }
        ((Map)this.cache).put(domain, cookiesForDomain);
        Set newValues2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)cookiesForDomain), (Function1)((Function1)new Function1<Cookie, Boolean>(this){
            final /* synthetic */ CookieManager this$0;

            public final boolean invoke(@NotNull Cookie it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.persistent() && !CookieManager.access$hasExpired(this.this$0, it);
            }
            {
                this.this$0 = cookieManager;
                super(1);
            }
        })), (Function1)saveFromResponse.newValues.2.INSTANCE));
        this.store.update(domain, newValues2);
    }

    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        List list;
        Cookie it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        List list2 = this.cache.get(url.host());
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = list3;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Cookie)element$iv$iv;
            boolean bl2 = false;
            if (!(!this.hasExpired(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cookies = (List)destination$iv$iv;
        if (url.isHttps()) {
            list = cookies;
        } else {
            $this$filter$iv = cookies;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Cookie)element$iv$iv;
                boolean bl3 = false;
                if (!(!it.secure())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public final synchronized void clear() {
        this.cache.clear();
        this.store.clear();
    }

    private final boolean hasExpired(Cookie $this$hasExpired) {
        return System.currentTimeMillis() >= $this$hasExpired.expiresAt();
    }

    /*
     * WARNING - void declaration
     */
    public CookieManager(@NotNull CookieStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
        boolean bl = false;
        this.cache = new HashMap();
        Object object = this.store.load();
        boolean bl2 = false;
        Iterator<Map.Entry<String, Set<String>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<String>> entry;
            Map.Entry<String, Set<String>> entry2 = entry = iterator.next();
            boolean bl3 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            Set<String> cookies = entry2.getValue();
            try {
                void $this$filterTo$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                void domain;
                if (HttpUrl.Companion.parse("http://" + (String)domain) == null) {
                    continue;
                }
                Iterable $this$mapNotNull$iv = cookies;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Cookie cookie;
                    HttpUrl url;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl4 = false;
                    String it = (String)element$iv$iv;
                    boolean bl5 = false;
                    if (Cookie.Companion.parse(url, it) == null) continue;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Cookie it$iv$iv = cookie;
                    boolean bl8 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapNotNullTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Cookie it = (Cookie)element$iv$iv;
                    boolean bl9 = false;
                    if (!(!this.hasExpired(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List nonExpiredCookies = (List)destination$iv$iv;
                ((Map)this.cache).put(domain, nonExpiredCookies);
            }
            catch (Exception exception) {}
        }
    }

    public static final /* synthetic */ boolean access$hasExpired(CookieManager $this, Cookie $this$access_u24hasExpired) {
        return $this.hasExpired($this$access_u24hasExpired);
    }
}

