/*
 * Decompiled with CFR 0.152.
 */
package tachiyomi.core.http;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import tachiyomi.core.http.CloudflareException;
import tachiyomi.core.http.JS;
import tachiyomi.core.http.JSFactory;
import tachiyomi.core.http.RequestsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0014"}, d2={"Ltachiyomi/core/http/CloudflareInterceptor;", "Lokhttp3/Interceptor;", "jsFactory", "Ltachiyomi/core/http/JSFactory;", "(Ltachiyomi/core/http/JSFactory;)V", "challengePattern", "Lkotlin/text/Regex;", "operationPattern", "passPattern", "serverCheck", "", "", "[Ljava/lang/String;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "resolveChallenge", "Lokhttp3/Request;", "response", "common"})
public final class CloudflareInterceptor
implements Interceptor {
    private final Regex operationPattern;
    private final Regex passPattern;
    private final Regex challengePattern;
    private final String[] serverCheck;
    private final JSFactory jsFactory;

    @NotNull
    public synchronized Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Response response = chain.proceed(chain.request());
        if (response.code() == 503 && ArraysKt.contains((Object[])this.serverCheck, (Object)Response.header$default((Response)response, (String)"Server", null, (int)2, null))) {
            return chain.proceed(this.resolveChallenge(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Request resolveChallenge(Response response) {
        Closeable closeable = this.jsFactory.create();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            double d;
            String pass;
            JS jsClient = (JS)closeable;
            boolean bl3 = false;
            Request originalRequest = response.request();
            HttpUrl url = originalRequest.url();
            String domain = url.host();
            ResponseBody responseBody = response.body();
            Intrinsics.checkNotNull((Object)responseBody);
            String content = responseBody.string();
            Thread.sleep(4000L);
            MatchResult matchResult = Regex.find$default((Regex)this.operationPattern, (CharSequence)content, (int)0, (int)2, null);
            String operation = matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
            MatchResult matchResult2 = Regex.find$default((Regex)this.challengePattern, (CharSequence)content, (int)0, (int)2, null);
            String challenge = matchResult2 != null && (matchResult2 = matchResult2.getGroups()) != null && (matchResult2 = matchResult2.get(1)) != null ? matchResult2.getValue() : null;
            MatchResult matchResult3 = Regex.find$default((Regex)this.passPattern, (CharSequence)content, (int)0, (int)2, null);
            String string = matchResult3 != null && (matchResult3 = matchResult3.getGroups()) != null && (matchResult3 = matchResult3.get(1)) != null ? matchResult3.getValue() : (pass = null);
            if (operation == null || challenge == null || pass == null) {
                throw (Throwable)new CloudflareException("Either operation, challenge or pass is null");
            }
            try {
                CharSequence charSequence = operation;
                Regex regex = new Regex("a\\.value = (.+ \\+ t\\.length).+");
                String string2 = "$1";
                boolean bl4 = false;
                charSequence = regex.replace(charSequence, string2);
                regex = new Regex("\\s{3,}[a-z](?: = |\\.).+");
                string2 = "";
                bl4 = false;
                String script = StringsKt.replace$default((String)StringsKt.replace$default((String)regex.replace(charSequence, string2), (String)"t.length", (String)String.valueOf(domain.length()), (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null);
                d = jsClient.evaluateAsDouble(script);
            }
            catch (Exception e) {
                throw (Throwable)new CloudflareException("Failed to resolve script with challenge", e);
            }
            double result = d;
            String cloudflareUrl = HttpUrl.Companion.get(url.scheme() + "://" + domain + "/cdn-cgi/l/chk_jschl").newBuilder().addQueryParameter("jschl_vc", challenge).addQueryParameter("pass", pass).addQueryParameter("jschl_answer", String.valueOf(result)).toString();
            Headers cloudflareHeaders = originalRequest.headers().newBuilder().add("Referer", url.toString()).add("Accept", "text/html,application/xhtml+xml,application/xml").add("Accept-Language", "en").build();
            Request request = RequestsKt.GET(cloudflareUrl, cloudflareHeaders, new CacheControl.Builder().build());
            return request;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public CloudflareInterceptor(@NotNull JSFactory jsFactory) {
        Intrinsics.checkNotNullParameter((Object)jsFactory, (String)"jsFactory");
        this.jsFactory = jsFactory;
        this.operationPattern = new Regex("setTimeout\\(function\\(\\)\\{\\s+(var (?:\\w,)+f.+?\\r?\\n[\\s\\S]+?a\\.value =.+?)\\r?\\n");
        this.passPattern = new Regex("name=\"pass\" value=\"(.+?)\"");
        this.challengePattern = new Regex("name=\"jschl_vc\" value=\"(\\w+)\"");
        this.serverCheck = new String[]{"cloudflare-nginx", "cloudflare"};
    }
}

