package idv.neo.utils.progressdownloader;

import android.util.Log;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

import idv.neo.utils.download.progress.DownloadProgressResponseBody;
import okhttp3.HttpUrl;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Streaming;
import retrofit2.http.Url;
/**
 * https://www.jianshu.com/p/e097adbf3770
 * http://blog.csdn.net/wzgiceman/article/details/52911503
 * Created by Neo on 2018/3/3.
 */

public class RetrofitProgressDownloader {
    public static final String TAG = "RetrofitProgressDownloader";
    private String mDownloadUrl;
    private Retrofit sRetrofit;
    private File mDestination;
    private DownloadProgressResponseBody.ProgressListener mProgressListener;

    public RetrofitProgressDownloader(String url, File destination, boolean isdebug, int timeout, DownloadProgressResponseBody.ProgressListener progressListener) {
        this.mDownloadUrl = url;
        this.mDestination = destination;
        this.mProgressListener = progressListener;
        sRetrofit = new Retrofit.Builder().baseUrl(mDownloadUrl).build();
    }

    // startsPoint指定开始下载的点
    public void download(final String downloadpath, File savefile) {
        mDestination = savefile;
        final Call<ResponseBody> request = sRetrofit.create(DownloadInterface.class).downloadFromDynamicPath(downloadpath);
        try {
            saveFile(request.request().url(), request.execute().body(), 0L);
        } catch (IOException e) {
            Log.d(TAG, "Call Get Exception : " + e);
            if (null != mProgressListener) {
                mProgressListener.exceptionUpdate(request.request().url(), e);
            }
        }
    }

    public void downloadwithBreakPoint(final String downloadpath, File savefile, final long startsPoint) {
        mDestination = savefile;
        final Call<ResponseBody> request = sRetrofit.create(DownloadInterface.class).downloadFromDynamicPathAndRange(String.valueOf(startsPoint), downloadpath);
        try {
            saveFile(request.request().url(), request.execute().body(), startsPoint);
        } catch (IOException e) {
            Log.d(TAG, "Call Get Exception : " + e);
            if (null != mProgressListener) {
                mProgressListener.exceptionUpdate(request.request().url(), e);
            }
        }
    }

    public void pause() {

    }

    private void saveFile(HttpUrl url, ResponseBody body, long startsPoint) throws IOException {
        final InputStream in = body.byteStream();
        FileChannel channelOut = null;
        // 随机访问文件，可以指定断点续传的起始位置
        RandomAccessFile randomAccessFile = null;
        final long fileSize = body.contentLength();
        if (null != mProgressListener) {
            mProgressListener.onPreExecute(url, fileSize);
        }
        try {
            randomAccessFile = new RandomAccessFile(mDestination, "rwd");
            //Chanel NIO中的用法，由于RandomAccessFile没有使用缓存策略，直接使用会使得下载速度变慢，亲测缓存下载3.3秒的文件，用普通的RandomAccessFile需要20多秒。
            channelOut = randomAccessFile.getChannel();
            // 内存映射，直接使用RandomAccessFile，是用其seek方法指定下载的起始位置，使用缓存下载，在这里指定下载位置。
            //FIXME https://fucknmb.com/2017/11/06/Android-FileChannel%E7%9A%84%E5%9D%91/
            // IllegalArgumentException: position=0 size=-1
            MappedByteBuffer mappedBuffer = channelOut.map(FileChannel.MapMode.READ_WRITE, startsPoint, fileSize);
            Log.d(TAG, "saveFile startsPoint : " + startsPoint);
            Log.d(TAG, "saveFile contentLength : " + fileSize);
            byte[] buffer = new byte[1024];
            int len;
            long fileSizeDownloaded = 0;
            long total = 0;
            long startTime = System.currentTimeMillis();
            int timeCount = 1;
            while ((len = in.read(buffer)) != -1) {
                total += len;
//                Log.d(TAG, "saveFile ... _________ : ");
//                Log.d(TAG, "saveFile ... run : ");
//                Log.d(TAG, "saveFile ... run len : " + len);
//                Log.d(TAG, "saveFile ... run total : " + total);
//                final int totalFileSize = (int) (fileSize / (Math.pow(1024, 2)));
//                final double current = Math.round(total / (Math.pow(1024, 2)));
//                final int progress = (int) ((total * 100) / fileSize);
                if (null != mProgressListener) {
                    mProgressListener.update(url, fileSize, total, false, null);
                }
                final long currentTime = System.currentTimeMillis() - startTime;
//                Log.d(TAG, "saveFile ... totalFileSize : " + totalFileSize);
//                Log.d(TAG, "saveFile ... current : " + current);
//                Log.d(TAG, "saveFile ... progress : " + progress);
                Log.d(TAG, "saveFile ... currentTime : " + currentTime);
                Log.d(TAG, "saveFile ... fileSizeDownloaded : " + fileSizeDownloaded);
                mappedBuffer.put(buffer, 0, len);
                if (currentTime > 1000 * timeCount) {
                    Log.d(TAG, "saveFile ... timeCount : " + timeCount);
                    timeCount++;
                    Log.d(TAG, "saveFile ... timeCount : " + timeCount);
                }
                fileSizeDownloaded += len;
                Log.d(TAG, "saveFile ... fileSizeDownloaded : " + fileSizeDownloaded);
            }
        } catch (IOException e) {
            Log.d(TAG, "saveFile Get Exception : " + e);
            pause();
//            if (null != mProgressListener) {
//                mProgressListener.update(url, startsPoint, startsPoint, false, e);
//            }
            if (null != mProgressListener) {
                mProgressListener.exceptionUpdate(url, e);
            }
        } finally {
            try {
                in.close();
                if (channelOut != null) {
                    channelOut.close();
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            } catch (IOException e) {
                Log.d(TAG, "save finally IOException : " + e);
            }
        }
    }

//    private void saveFile(ResponseBody body,   long startsPoint) throws IOException {
//        int count;
//        byte data[] = new byte[1024 * 4];
//        if (null != mProgressListener) {
//            mProgressListener.onPreExecute(body.contentLength());
//        }
//        long fileSize = body.contentLength();
//        try {
//            Log.d(TAG, "Show Temp File path: " + mDestination.getAbsolutePath());
//            if (mDestination.exists() && fileSize == getFolderSize(mDestination)) {//FIXME
//                Log.d(TAG, "Show here  done TODO : "  );
//            } else {
//                InputStream inputStream = null;
//                OutputStream outputStream = null;
//                try {
//                    long fileSizeDownloaded = 0;
//                    inputStream = new BufferedInputStream(body.byteStream(), 1024 * 8);
//                    outputStream = new FileOutputStream(mDestination);
//                    long total = 0;
//                    long startTime = System.currentTimeMillis();
//                    int timeCount = 1;
//                    while ((count = inputStream.read(data)) != -1) {
//                        total += count;
//                        final int totalFileSize = (int) (fileSize / (Math.pow(1024, 2)));
//                        final double current = Math.round(total / (Math.pow(1024, 2)));
//                        final int progress = (int) ((total * 100) / fileSize);
//                        final long currentTime = System.currentTimeMillis() - startTime;
//                        Log.d(TAG, "saveFile ... totalFileSize : " + totalFileSize);
//                        Log.d(TAG, "saveFile ... current : " + current);
//                        Log.d(TAG, "saveFile ... progress : " + progress);
//                        Log.d(TAG, "saveFile ... currentTime : " + currentTime);
//                        outputStream.write(data, 0, count);
//                        fileSizeDownloaded += count;
//                    }
//
//                    outputStream.flush();
//                    Log.d(TAG, "file download finish  Show path : " + mDestination.getAbsolutePath());
//                } catch (IOException e) {
//                    Log.d(TAG, "downloadFile get Exception @ write file : " + e);
//                    Log.d(TAG, "Show here  pause : "  );
//                } finally {
//                    if (inputStream != null) {
//                        inputStream.close();
//                    }
//                    if (outputStream != null) {
//                        outputStream.close();
//                    }
//                }
//            }
//        } catch (IOException e) {
//            Log.d(TAG, "downloadFile get Exception  : " + e);
//            Log.d(TAG, "Show here  pause 2: "  );
//        }
//    }

//    private void downloadFile(ResponseBody body, String statustext, File savefile, String completetext) throws IOException {
//        int count;
//        byte data[] = new byte[1024 * 4];
//        if (mContentLength == 0L) {
//            mContentLength = body.contentLength();
//        }
//        long fileSize = body.contentLength();
//        try {
//            mFinishFile = savefile;
//            Log.d(TAG, "Show Temp File path: " + mFinishFile.getAbsolutePath());
//            if (mFinishFile.exists() && mBreakPoints == getFolderSize(mFinishFile)) {//FIXME
//                mBreakPoints = 0L;
//                onDownloadComplete(mFinishFile.getAbsolutePath(), completetext);
//            } else {
//                InputStream inputStream = null;
//                OutputStream outputStream = null;
//                try {
//                    long fileSizeDownloaded = 0;
//                    inputStream = new BufferedInputStream(body.byteStream(), 1024 * 8);
//                    outputStream = new FileOutputStream(mFinishFile);
//                    long total = 0;
//                    long startTime = System.currentTimeMillis();
//                    int timeCount = 1;
//                    while ((count = inputStream.read(data)) != -1) {
//                        total += count;
//                        final int totalFileSize = (int) (fileSize / (Math.pow(1024, 2)));
//                        final double current = Math.round(total / (Math.pow(1024, 2)));
//                        final int progress = (int) ((total * 100) / fileSize);
//                        final long currentTime = System.currentTimeMillis() - startTime;
//                        final DownloadObject download = new DownloadObject();
//                        download.setTotalFileSize(totalFileSize);
//                        if (currentTime > 1000 * timeCount) {
//                            download.setCurrentFileSize((int) current);
//                            download.setProgress(progress);
//                            download.setDone(false);
//                            sendNotification(statustext, download);
//                            timeCount++;
//                        }
//                        outputStream.write(data, 0, count);
//                        fileSizeDownloaded += count;
//                        mTotalBytes = fileSizeDownloaded;
//                    }
//                    mBreakPoints = mTotalBytes;
//                    onDownloadComplete(mFinishFile.getAbsolutePath(), completetext);
//                    outputStream.flush();
//                    Log.d(TAG, "file download finish  Show path : " + mFinishFile.getAbsolutePath());
//                } catch (IOException e) {
//                    Log.d(TAG, "downloadFile get Exception @ write file : " + e);
//                    mBreakPoints = mTotalBytes;
//                } finally {
//                    if (inputStream != null) {
//                        inputStream.close();
//                    }
//                    if (outputStream != null) {
//                        outputStream.close();
//                    }
//                }
//            }
//        } catch (IOException e) {
//            Log.d(TAG, "downloadFile get Exception  : " + e);
//        }
//    }

    private static long getFolderSize(File f) {
        long size = 0;
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                size += getFolderSize(file);
            }
        } else {
            size = f.length();
        }
        return size;
    }

    public interface DownloadInterface {
        //https://www.jianshu.com/p/582e0a4a4ee9
        @Streaming
        @GET()
        Call<ResponseBody> downloadFromDynamicPath(@Url String path);

        @Streaming
        @GET()
        Call<ResponseBody> downloadFromDynamicPathWithAuth(@Header("Authorization") String auth, @Url String path);

        @Streaming
        @GET()
        Call<ResponseBody> downloadFromDynamicPathAndRange(@Header("Range") String range, @Url String path);

        @Streaming
        @GET()
        Call<ResponseBody> downloadFromDynamicPathAndRangeWithAuth(@Header("Authorization") String auth, @Header("Range") String range, @Url String path);
    }
}
