/*
 * Decompiled with CFR 0.152.
 */
package systems.vostok.tda.component;

import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;
import scala.runtime.RichInt$;
import systems.vostok.tda.component.AddressTranslator$;
import systems.vostok.tda.domain.Mapper;
import systems.vostok.tda.exception.NoTargetDistrictException;
import systems.vostok.tda.util.DataHelper$;
import systems.vostok.tda.util.constants.BuildingType$;

public final class DistrictMapper$ {
    public static DistrictMapper$ MODULE$;

    static {
        new DistrictMapper$();
    }

    public String mapAddressToDistrict(List<Mapper> adoptedMapperData, String building, Enumeration.Value buildingType) {
        String string;
        String string2 = ((Mapper)adoptedMapperData.head()).building();
        String string3 = "";
        if (!(string2 == null ? string3 != null : !string2.equals(string3)) || ((Mapper)adoptedMapperData.head()).building() == null) {
            string = ((Mapper)adoptedMapperData.head()).districtId();
        } else {
            Option option = DistrictMapper$.mapperOption$1(adoptedMapperData, building, buildingType);
            if (!(option instanceof Some)) {
                throw new NoTargetDistrictException();
            }
            Some some = (Some)option;
            Mapper mapperOption = (Mapper)some.value();
            String string4 = mapperOption.districtId();
            string = string4;
        }
        return string;
    }

    public boolean checkAccordance(Mapper mapper, String building, Enumeration.Value buildingType) {
        boolean bl;
        Enumeration.Value value = buildingType;
        Enumeration.Value value2 = BuildingType$.MODULE$.SIMPLE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = this.checkSimpleAccordance(mapper, building);
        } else {
            Enumeration.Value value4 = BuildingType$.MODULE$.LITERAL();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = this.checkLiteralAccordance(mapper, building);
            } else {
                Enumeration.Value value6 = BuildingType$.MODULE$.FRACTION();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    bl = this.checkFractionAccordance(mapper, building);
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return bl;
    }

    public boolean checkSimpleAccordance(Mapper mapper, String building) {
        return new StringOps(Predef$.MODULE$.augmentString(building)).toInt() <= new StringOps(Predef$.MODULE$.augmentString(mapper.buildingTo())).toInt() && new StringOps(Predef$.MODULE$.augmentString(building)).toInt() >= new StringOps(Predef$.MODULE$.augmentString(mapper.buildingFrom())).toInt();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkLiteralAccordance(Mapper mapper, String building) {
        boolean bl;
        String litFreeBuilding = DataHelper$.MODULE$.extractFirstDigits(building);
        String litFreeBuildingFrom = DataHelper$.MODULE$.extractFirstDigits(mapper.buildingFrom());
        String litFreeBuildingTo = DataHelper$.MODULE$.extractFirstDigits(mapper.buildingTo());
        String string = litFreeBuilding;
        String string2 = litFreeBuildingFrom;
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = litFreeBuilding;
            String string4 = litFreeBuildingTo;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                bl = this.checkSimpleAccordance(AddressTranslator$.MODULE$.translateSingleMapperToSimple(mapper), litFreeBuilding);
                return bl;
            }
        }
        String string5 = litFreeBuilding;
        String string6 = litFreeBuildingFrom;
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            String string7 = litFreeBuilding;
            String string8 = litFreeBuildingTo;
            if (string7 == null ? string8 != null : !string7.equals(string8)) {
                bl = this.compareLetters(DataHelper$.MODULE$.extractLetterLiteral(mapper.buildingFrom()), "\u042f", DataHelper$.MODULE$.extractLetterLiteral(building));
                return bl;
            }
        }
        String string9 = litFreeBuilding;
        String string10 = litFreeBuildingFrom;
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            String string11 = litFreeBuilding;
            String string12 = litFreeBuildingTo;
            if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                bl = this.compareLetters("\u0410", DataHelper$.MODULE$.extractLetterLiteral(mapper.buildingTo()), DataHelper$.MODULE$.extractLetterLiteral(building));
                return bl;
            }
        }
        String string13 = litFreeBuilding;
        String string14 = litFreeBuildingFrom;
        if (string13 == null) {
            if (string14 != null) {
                return false;
            }
        } else if (!string13.equals(string14)) return false;
        String string15 = litFreeBuilding;
        String string16 = litFreeBuildingTo;
        if (string15 == null) {
            if (string16 != null) {
                return false;
            }
        } else if (!string15.equals(string16)) return false;
        bl = this.compareLetters(DataHelper$.MODULE$.extractLetterLiteral(mapper.buildingFrom()), DataHelper$.MODULE$.extractLetterLiteral(mapper.buildingTo()), DataHelper$.MODULE$.extractLetterLiteral(building));
        return bl;
    }

    public boolean compareLetters(String letFrom, String letTo, String letBuilding) {
        String reassignedLetFrom = letFrom;
        if (letFrom == null) {
            reassignedLetFrom = "\u0410";
        }
        if (letTo == null) {
            return false;
        }
        return new RichChar(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(reassignedLetFrom)).head()))).to(new StringOps(Predef$.MODULE$.augmentString(letTo)).head()).contains(new StringOps(Predef$.MODULE$.augmentString(letBuilding)).head());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkFractionAccordance(Mapper mapper, String building) {
        boolean bl;
        String litFreeBuilding = DataHelper$.MODULE$.extractFirstDigits(building);
        String litFreeBuildingFrom = DataHelper$.MODULE$.extractFirstDigits(mapper.buildingFrom());
        String litFreeBuildingTo = DataHelper$.MODULE$.extractFirstDigits(mapper.buildingTo());
        String string = litFreeBuilding;
        String string2 = litFreeBuildingFrom;
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = litFreeBuilding;
            String string4 = litFreeBuildingTo;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                bl = this.checkSimpleAccordance(AddressTranslator$.MODULE$.translateSingleMapperToSimple(mapper), litFreeBuilding);
                return bl;
            }
        }
        String string5 = litFreeBuilding;
        String string6 = litFreeBuildingFrom;
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            String string7 = litFreeBuilding;
            String string8 = litFreeBuildingTo;
            if (string7 == null ? string8 != null : !string7.equals(string8)) {
                bl = this.compareNumbers(DataHelper$.MODULE$.extractNumericLiteral(mapper.buildingFrom()), "9999", DataHelper$.MODULE$.extractNumericLiteral(building));
                return bl;
            }
        }
        String string9 = litFreeBuilding;
        String string10 = litFreeBuildingFrom;
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            String string11 = litFreeBuilding;
            String string12 = litFreeBuildingTo;
            if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                bl = this.compareNumbers("0", DataHelper$.MODULE$.extractNumericLiteral(mapper.buildingTo()), DataHelper$.MODULE$.extractNumericLiteral(building));
                return bl;
            }
        }
        String string13 = litFreeBuilding;
        String string14 = litFreeBuildingFrom;
        if (string13 == null) {
            if (string14 != null) {
                return false;
            }
        } else if (!string13.equals(string14)) return false;
        String string15 = litFreeBuilding;
        String string16 = litFreeBuildingTo;
        if (string15 == null) {
            if (string16 != null) {
                return false;
            }
        } else if (!string15.equals(string16)) return false;
        bl = this.compareNumbers(DataHelper$.MODULE$.extractNumericLiteral(mapper.buildingFrom()), DataHelper$.MODULE$.extractNumericLiteral(mapper.buildingTo()), DataHelper$.MODULE$.extractNumericLiteral(building));
        return bl;
    }

    public boolean compareNumbers(String numFrom, String numTo, String numBuilding) {
        String reassignedNumFrom = numFrom;
        if (numFrom == null) {
            reassignedNumFrom = "0";
        }
        if (numTo == null) {
            return false;
        }
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(new StringOps(Predef$.MODULE$.augmentString(reassignedNumFrom)).toInt()), new StringOps(Predef$.MODULE$.augmentString(numTo)).toInt()).contains(new StringOps(Predef$.MODULE$.augmentString(numBuilding)).toInt());
    }

    private static final Option mapperOption$1(List adoptedMapperData$1, String building$1, Enumeration.Value buildingType$1) {
        return adoptedMapperData$1.find((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DistrictMapper$.MODULE$.checkAccordance(x$1, building$1, buildingType$1)));
    }

    private DistrictMapper$() {
        MODULE$ = this;
    }
}

