/*
 * Decompiled with CFR 0.152.
 */
package systems.vostok.tda.component;

import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import systems.vostok.tda.domain.Mapper;
import systems.vostok.tda.exception.IllegalBuildingFormatException;
import systems.vostok.tda.util.DataHelper$;
import systems.vostok.tda.util.constants.BuildingType$;

public final class AddressTranslator$ {
    public static AddressTranslator$ MODULE$;

    static {
        new AddressTranslator$();
    }

    public Enumeration.Value getBuildingType(String building) {
        Enumeration.Value value;
        String buildingUp = building.toUpperCase();
        if (buildingUp.matches("[0-9]*")) {
            value = BuildingType$.MODULE$.SIMPLE();
        } else if (buildingUp.contains("/")) {
            value = BuildingType$.MODULE$.FRACTION();
        } else if (buildingUp.matches(".*[\u0410-\u042f]")) {
            value = BuildingType$.MODULE$.LITERAL();
        } else {
            throw new IllegalBuildingFormatException(building);
        }
        return value;
    }

    public List<Mapper> translateMapper(List<Mapper> mappingData, Enumeration.Value buildingType) {
        Enumeration.Value value = buildingType;
        Enumeration.Value value2 = BuildingType$.MODULE$.SIMPLE();
        Enumeration.Value value3 = value;
        List<Mapper> list = !(value2 != null ? !value2.equals(value3) : value3 != null) ? this.translateDataForSimple(mappingData) : this.translateDataForComplex(mappingData, buildingType);
        return list;
    }

    public Mapper translateSingleMapperToSimple(Mapper singleMapper) {
        return new Mapper(singleMapper.streetId(), singleMapper.building(), DataHelper$.MODULE$.extractFirstDigits(singleMapper.buildingFrom()), DataHelper$.MODULE$.extractFirstDigits(singleMapper.buildingTo()), singleMapper.districtId());
    }

    public List<Mapper> translateDataForSimple(List<Mapper> mappingData) {
        return (List)mappingData.map((Function1 & java.io.Serializable & Serializable)mapper -> {
            Mapper mapper2;
            String string = mapper.building();
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2)) || mapper.building() == null) {
                mapper2 = mapper;
            } else {
                String rawBuildingsFrom = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapper.building().split("-"))).head();
                if (List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{BuildingType$.MODULE$.FRACTION(), BuildingType$.MODULE$.LITERAL()})).contains((Object)MODULE$.getBuildingType(rawBuildingsFrom))) {
                    mapper.buildingFrom_$eq(((Object)BoxesRunTime.boxToInteger((int)(new StringOps(Predef$.MODULE$.augmentString(DataHelper$.MODULE$.extractFirstDigits(rawBuildingsFrom))).toInt() + 1))).toString());
                } else {
                    mapper.buildingFrom_$eq(DataHelper$.MODULE$.extractFirstDigits(rawBuildingsFrom));
                }
                mapper.buildingTo_$eq(DataHelper$.MODULE$.extractFirstDigits((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapper.building().split("-"))).last()));
                mapper2 = mapper;
            }
            return mapper2;
        }, List$.MODULE$.canBuildFrom());
    }

    public List<Mapper> translateDataForComplex(List<Mapper> mappingData, Enumeration.Value buildingType) {
        return (List)mappingData.map((Function1 & java.io.Serializable & Serializable)mapper -> {
            Mapper mapper2;
            String string = mapper.building();
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                mapper2 = mapper;
            } else {
                String rawBuildingsFrom = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(mapper.building())).split('-'))).head();
                String rawBuildingsTo = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(mapper.building())).split('-'))).last();
                if (List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{buildingType, BuildingType$.MODULE$.SIMPLE()})).contains((Object)MODULE$.getBuildingType(rawBuildingsFrom))) {
                    mapper.buildingFrom_$eq(rawBuildingsFrom);
                } else {
                    mapper.buildingFrom_$eq(((Object)BoxesRunTime.boxToInteger((int)(new StringOps(Predef$.MODULE$.augmentString(DataHelper$.MODULE$.extractFirstDigits(rawBuildingsFrom))).toInt() + 1))).toString());
                }
                if (List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{buildingType, BuildingType$.MODULE$.SIMPLE()})).contains((Object)MODULE$.getBuildingType(rawBuildingsTo))) {
                    mapper.buildingTo_$eq(rawBuildingsTo);
                } else {
                    mapper.buildingTo_$eq(DataHelper$.MODULE$.extractFirstDigits(rawBuildingsTo));
                }
                mapper2 = mapper;
            }
            return mapper2;
        }, List$.MODULE$.canBuildFrom());
    }

    private AddressTranslator$() {
        MODULE$ = this;
    }
}

