/*
 * Decompiled with CFR 0.152.
 */
package systems.vostok.tda.component;

import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import systems.vostok.tda.domain.Address;
import systems.vostok.tda.domain.Mapper;
import systems.vostok.tda.exception.IllegalBuildingFormatException;
import systems.vostok.tda.exception.IllegalEntityIdFormatException;
import systems.vostok.tda.exception.NoMapperDataException;
import systems.vostok.tda.exception.NotCompatibleMapperException;

public final class AccuracyChecker$ {
    public static AccuracyChecker$ MODULE$;

    static {
        new AccuracyChecker$();
    }

    public boolean checkAddressConsistence(Address address) {
        this.checkEntityId(address.streetId());
        this.checkEntityId(address.building());
        return this.checkBuilding(address.building());
    }

    public boolean checkMapperConsistence(List<Mapper> mapper) {
        if (mapper.isEmpty()) {
            throw new NoMapperDataException();
        }
        mapper.foreach((Function1 & java.io.Serializable & Serializable)mapperLine -> {
            Object object;
            MODULE$.checkEntityId(mapperLine.streetId());
            MODULE$.checkEntityId(mapperLine.districtId());
            String string = mapperLine.building();
            String string2 = "";
            if ((string == null ? string2 != null : !string.equals(string2)) && mapperLine.building() != null) {
                MODULE$.checkBuilding(new StringOps(Predef$.MODULE$.augmentString(mapperLine.building())).split('-')[0]);
                object = BoxesRunTime.boxToBoolean((boolean)MODULE$.checkBuilding(new StringOps(Predef$.MODULE$.augmentString(mapperLine.building())).split('-')[1]));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return true;
    }

    public boolean checkAddressMapperCompatibility(Address address, List<Mapper> mapper) {
        mapper.foreach((Function1 & java.io.Serializable & Serializable)mapperLine -> {
            AccuracyChecker$.$anonfun$checkAddressMapperCompatibility$1(address, mapperLine);
            return BoxedUnit.UNIT;
        });
        return true;
    }

    public boolean checkEntityId(String id) {
        block3: {
            block2: {
                if (id == null) break block2;
                String string = id;
                String string2 = "";
                if ((string == null ? string2 != null : !string.equals(string2)) && !id.contains(" ")) break block3;
            }
            throw new IllegalEntityIdFormatException(id);
        }
        return true;
    }

    public boolean checkBuilding(String building) {
        if (building != null) {
            String string = building;
            String string2 = "";
            if ((string == null ? string2 != null : !string.equals(string2)) && !building.contains(" ")) {
                String buildingUp = building.toUpperCase();
                if (buildingUp.matches("[0-9/]*")) {
                    return true;
                }
                if (buildingUp.matches(".\\d*\\/.\\d*")) {
                    String string3;
                    Regex pattern = new StringOps(Predef$.MODULE$.augmentString("(.\\d*)\\/(.\\d*)")).r();
                    Option option = pattern.unapplySeq((CharSequence)(string3 = buildingUp));
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
                        throw new MatchError((Object)string3);
                    }
                    String firstLit = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String secondLit = (String)((LinearSeqOptimized)option.get()).apply(1);
                    Tuple2 tuple2 = new Tuple2((Object)firstLit, (Object)secondLit);
                    Tuple2 tuple22 = tuple2;
                    String firstLit2 = (String)tuple22._1();
                    String secondLit2 = (String)tuple22._2();
                    if (firstLit2.matches("[1-9]*") && secondLit2.matches("[1-9]*")) {
                        return true;
                    }
                } else if (buildingUp.matches(".\\d*[\u0410-\u042f]")) {
                    return true;
                }
            }
        }
        throw new IllegalBuildingFormatException(building);
    }

    public static final /* synthetic */ void $anonfun$checkAddressMapperCompatibility$1(Address address$1, Mapper mapperLine) {
        String string = address$1.streetId();
        String string2 = mapperLine.streetId();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new NotCompatibleMapperException(address$1.streetId(), mapperLine.streetId());
        }
    }

    private AccuracyChecker$() {
        MODULE$ = this;
    }
}

