/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import javax.measure.MetricPrefix;
import javax.measure.Unit;
import org.junit.Assert;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import systems.uom.ucum.format.UCUMFormatTestBase;
import systems.uom.ucum.internal.format.TokenException;

public class UCUMFormatTable5Test
extends UCUMFormatTestBase {
    @Test
    public void testParseUCUMCILowercaseLiter() {
        Assert.assertEquals((Object)UCUM.LITER_DM3, (Object)FORMAT_CI.parse((CharSequence)"l"));
    }

    @Test
    public void testParseUCUMCIUppercaseLiter() {
        Assert.assertEquals((Object)UCUM.LITER_DM3, (Object)FORMAT_CI.parse((CharSequence)"L"));
    }

    @Test
    public void testParseUCUMCSLowercaseLiter() {
        Assert.assertEquals((Object)UCUM.LITER_DM3, (Object)FORMAT_CS.parse((CharSequence)"l"));
    }

    @Test
    public void testParseUCUMCSUppercaseLiter() {
        Assert.assertEquals((Object)UCUM.LITER, (Object)FORMAT_CS.parse((CharSequence)"L"));
    }

    @Test
    public void testFormatUCUMCI() {
        Assert.assertEquals((Object)"L", (Object)FORMAT_CI.format(UCUM.LITER_DM3));
    }

    @Test
    public void testFormatUCUMCS() {
        Assert.assertEquals((Object)"l", (Object)FORMAT_CS.format(UCUM.LITER_DM3));
    }

    @Test
    public void testFormatUCUMPrint() {
        Assert.assertEquals((Object)"L", (Object)FORMAT_PRINT.format(UCUM.LITER));
    }

    @Test
    public void testFormatUCUMPrintDm3() {
        Assert.assertEquals((Object)"l", (Object)FORMAT_PRINT.format(UCUM.LITER_DM3));
    }

    @Test
    public void testFormatUCUMCIDeciDm3() {
        Unit deciliter = MetricPrefix.DECI((Unit)UCUM.LITER_DM3);
        Assert.assertEquals((Object)"DL", (Object)FORMAT_CI.format(deciliter));
    }

    @Test
    public void testFormatUCUMCSDeciDm3() {
        Unit deciliter = MetricPrefix.DECI((Unit)UCUM.LITER_DM3);
        Assert.assertEquals((Object)"dl", (Object)FORMAT_CS.format(deciliter));
    }

    @Test
    public void testParseUCUMCIDeciDm3() {
        Unit deciliter2 = FORMAT_CI.parse((CharSequence)"dl");
        Assert.assertEquals((Object)MetricPrefix.DECI((Unit)UCUM.LITER_DM3), (Object)deciliter2);
    }

    @Test
    public void testParseUCUMCSDeciDm3() {
        Unit dl3 = FORMAT_CS.parse((CharSequence)"dl");
        Assert.assertEquals((Object)MetricPrefix.DECI((Unit)UCUM.LITER_DM3), (Object)dl3);
    }

    @Test
    public void testParseUCUMCSMicroDm3() {
        Unit microliter = FORMAT_CS.parse((CharSequence)"ul");
        Assert.assertEquals((Object)MetricPrefix.MICRO((Unit)UCUM.LITER_DM3), (Object)microliter);
    }

    @Test(expected=TokenException.class)
    public void testParseUCUMCSMicroFail() {
        Unit microliter = FORMAT_CS.parse((CharSequence)"UL");
        Assert.assertEquals((Object)MetricPrefix.MICRO((Unit)UCUM.LITER_DM3), (Object)microliter);
    }

    @Test
    public void testParseUCUMCIMicro() {
        Unit microliter = FORMAT_CI.parse((CharSequence)"UL");
        Assert.assertEquals((Object)MetricPrefix.MICRO((Unit)UCUM.LITER_DM3), (Object)microliter);
    }

    @Test
    public void testParseUCUMCSMicro() {
        Unit microliter = FORMAT_CS.parse((CharSequence)"uL");
        Assert.assertEquals((Object)MetricPrefix.MICRO((Unit)UCUM.LITER), (Object)microliter);
    }
}

