/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;

public class UnitsTest {
    static final Logger logger = Logger.getLogger(UnitsTest.class.getName());
    Unit<Dimensionless> one;

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.one = AbstractUnit.ONE;
    }

    @After
    public void tearDown() throws Exception {
        this.one = null;
    }

    @Test
    public void testConverterToSI() {
        Double factor = 10.0;
        UnitConverter converter = this.one.getConverterTo(this.one);
        Double result = converter.convert(factor.doubleValue());
        Assert.assertEquals((Object)result, (Object)factor);
        logger.log(Level.FINER, result.toString());
    }

    @Test
    public void testAsTypeValid() {
        this.one.asType(Dimensionless.class);
    }

    @Test(expected=ClassCastException.class)
    public void testAsTypeFails() {
        UCUM.METER.asType(Dimensionless.class);
    }

    @Test
    public void testGetDimension() {
        this.one.getDimension();
    }

    @Test
    public void testAlternate() {
        Unit alternate = this.one.alternate(null);
        Assert.assertNotNull((Object)alternate);
    }

    @Test
    public void testTransform() {
        Unit result = this.one.transform((UnitConverter)AbstractConverter.IDENTITY);
        Assert.assertEquals((Object)result, this.one);
    }

    @Test
    public void testShift() {
        Unit result = this.one.shift(10.0);
        Assert.assertNotSame((Object)result, this.one);
    }

    @Test
    public void testMultiplyLong() {
        Unit result = this.one.multiply(2.0);
        Assert.assertNotSame((Object)result, this.one);
    }

    @Test
    public void testMultiplyDouble() {
        Unit result = this.one.multiply(2.1);
        Assert.assertNotSame((Object)result, this.one);
    }

    @Test
    public void testMultiplyUnitOfQ() {
        AbstractUnit result = (AbstractUnit)this.one.multiply(this.one);
        Assert.assertEquals((Object)result, this.one);
    }

    @Test
    public void testInverse() {
        Unit result = this.one.inverse();
        Assert.assertEquals((Object)result, this.one);
    }

    @Test
    public void testDivideLong() {
        Unit result = this.one.divide(2.0);
        Assert.assertNotSame((Object)result, this.one);
    }

    @Test
    public void testDivideDouble() {
        Unit result = this.one.divide(3.2);
        Assert.assertNotSame((Object)result, this.one);
    }

    @Test
    public void testDivideUnitOfQ() {
        Unit result = this.one.divide(this.one);
        Assert.assertEquals((Object)result, this.one);
    }

    @Test
    public void testRoot() {
        Unit result = this.one.root(2);
        Assert.assertEquals((Object)result, this.one);
    }

    @Test
    public void testPow() {
        Unit result = this.one.pow(10);
        Assert.assertEquals(this.one, (Object)result);
    }

    @Test
    public void testKiloIsAThousand() {
        ComparableQuantity w2000 = Quantities.getQuantity((Number)2000, (Unit)UCUM.WATT);
        ComparableQuantity kW2 = Quantities.getQuantity((Number)2, (Unit)MetricPrefix.KILO((Unit)UCUM.WATT));
    }

    @Test
    public void testOf() {
        Assert.assertEquals((Object)MetricPrefix.KILO((Unit)Units.GRAM).toString(), (Object)AbstractUnit.parse((CharSequence)"kg").toString());
    }

    @Test
    public void testParse() {
        Assert.assertEquals((Object)MetricPrefix.KILO((Unit)UCUM.GRAM).toString(), (Object)AbstractUnit.parse((CharSequence)"kg").toString());
    }

    @Test
    public void testAnnotate() {
    }

    @Test
    public void testGetAnnotation() {
    }

    @Test
    public void testGetUnannotatedUnit() {
    }

    @Test
    public void testIsSystemUnit() {
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"kg", (Object)MetricPrefix.KILO((Unit)UCUM.GRAM).toString());
        Assert.assertEquals((Object)"lb", (Object)UCUM.POUND.toString());
        Assert.assertEquals((Object)"oz", (Object)UCUM.OUNCE.toString());
        Assert.assertEquals((Object)"g", (Object)UCUM.GRAM.toString());
        Assert.assertEquals((Object)"lb", (Object)UCUM.POUND.toString());
    }

    @Test
    public void testGetConverterToSystemUnit() {
    }

    @Test
    public void testGetSymbol() {
        Assert.assertEquals((Object)"kg", (Object)Units.KILOGRAM.getSymbol());
        Assert.assertNull((Object)MetricPrefix.KILO((Unit)UCUM.GRAM).getSymbol());
        Assert.assertNull((Object)UCUM.GRAM.getSymbol());
        Assert.assertNull((Object)UCUM.OUNCE.getSymbol());
    }

    @Test
    public void testGetParentUnit() {
        Assert.assertEquals((Object)"TransformedUnit", (Object)Units.GRAM.getClass().getSimpleName());
        Assert.assertEquals((Object)"kg", (Object)((TransformedUnit)Units.GRAM).getParentUnit().getSymbol());
    }

    @Test
    public void testGetSystemUnit() {
    }

    @Test
    public void testGetProductUnits() {
    }

    @Test
    public void testIsCompatible() {
    }

    @Test
    public void testGetConverterTo() {
    }

    @Test
    public void testGetConverterToAny() {
    }

    @Test
    public void testAdd() {
    }

    @Test
    public void testMultiply_double() {
    }

    @Test
    public void testMultiply_ErrorType() {
    }

    @Test
    public void testDivide_double() {
    }

    @Test
    public void testDivide_ErrorType() {
    }

    @Test
    public void testHashCode() {
    }

    @Test
    public void testEquals() {
    }
}

