/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum;

import java.util.List;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SystemOfUnitsServiceTest {
    private static final String EXPECTED_SYSTEM_NAME = "Unified Code for Units of Measure";
    private static final int NUM_OF_UNITS = 245;
    private static SystemOfUnitsService defaultService;

    @BeforeClass
    public static void setUp() {
        defaultService = ServiceProvider.current().getSystemOfUnitsService();
    }

    @Test
    public void testDefaultUnitSystemService() {
        Assert.assertNotNull((Object)defaultService);
        Assert.assertEquals((Object)"systems.uom.ucum.spi.UCUMSystemService", (Object)defaultService.getClass().getName());
        SystemOfUnits system = defaultService.getSystemOfUnits();
        Assert.assertNotNull((Object)system);
        Assert.assertEquals((Object)"systems.uom.ucum.UCUM", (Object)system.getClass().getName());
        Assert.assertEquals((Object)EXPECTED_SYSTEM_NAME, (Object)system.getName());
        Assert.assertNotNull((Object)system.getUnits());
        Assert.assertEquals((long)245L, (long)system.getUnits().size());
    }

    @Test
    public void testUnitSystemServiceAlias() {
        Assert.assertNotNull((Object)defaultService);
        Assert.assertEquals((Object)"systems.uom.ucum.spi.UCUMSystemService", (Object)defaultService.getClass().getName());
        SystemOfUnits system = defaultService.getSystemOfUnits("UCUM");
        Assert.assertNotNull((Object)system);
        Assert.assertEquals((Object)"systems.uom.ucum.UCUM", (Object)system.getClass().getName());
        Assert.assertEquals((Object)EXPECTED_SYSTEM_NAME, (Object)system.getName());
        Assert.assertNotNull((Object)system.getUnits());
        Assert.assertEquals((long)245L, (long)system.getUnits().size());
        SystemOfUnits system2 = defaultService.getSystemOfUnits(EXPECTED_SYSTEM_NAME);
        Assert.assertEquals((Object)system, (Object)system2);
    }

    @Test
    public void testOtherUnitSystemServices() {
        List services = ServiceProvider.available();
        Assert.assertNotNull((Object)services);
        Assert.assertEquals((long)3L, (long)services.size());
    }
}

