/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.spi;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.format.QuantityFormat;
import javax.measure.format.UnitFormat;
import javax.measure.spi.FormatService;
import systems.uom.ucum.format.UCUMFormat;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.FormatBehavior;
import tech.units.indriya.format.NumberDelimiterQuantityFormat;
import tech.units.indriya.format.SimpleQuantityFormat;

public final class UCUMFormatService
implements FormatService {
    private static final String DEFAULT_UNIT_FORMAT = UCUMFormat.Variant.CASE_SENSITIVE.name();
    private final Map<String, UnitFormat> unitFormats = new HashMap<String, UnitFormat>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private static final String DEFAULT_QUANTITY_FORMAT = "Simple";
    private static final NumberDelimiterQuantityFormat EBNF_QUANTITY_FORMAT = new NumberDelimiterQuantityFormat.Builder().setNumberFormat(NumberFormat.getInstance(Locale.ROOT)).setUnitFormat((UnitFormat)EBNFUnitFormat.getInstance()).build();
    private final Map<String, QuantityFormat> quantityFormats = new HashMap<String, QuantityFormat>();

    public UCUMFormatService() {
        this.quantityFormats.put(DEFAULT_QUANTITY_FORMAT, (QuantityFormat)SimpleQuantityFormat.getInstance());
        this.quantityFormats.put("NumberDelimiter", (QuantityFormat)NumberDelimiterQuantityFormat.getInstance());
        this.quantityFormats.put("EBNF", (QuantityFormat)EBNF_QUANTITY_FORMAT);
        this.quantityFormats.put("Local", (QuantityFormat)NumberDelimiterQuantityFormat.getInstance((FormatBehavior)FormatBehavior.LOCALE_SENSITIVE));
        this.unitFormats.put(DEFAULT_UNIT_FORMAT, (UnitFormat)UCUMFormat.getInstance(UCUMFormat.Variant.CASE_SENSITIVE));
        this.unitFormats.put(UCUMFormat.Variant.CASE_INSENSITIVE.name(), (UnitFormat)UCUMFormat.getInstance(UCUMFormat.Variant.CASE_INSENSITIVE));
        this.unitFormats.put(UCUMFormat.Variant.PRINT.name(), (UnitFormat)UCUMFormat.getInstance(UCUMFormat.Variant.PRINT));
        this.aliases.put("UCUM", DEFAULT_UNIT_FORMAT);
        this.aliases.put("CS", DEFAULT_UNIT_FORMAT);
        this.aliases.put("C/S", DEFAULT_UNIT_FORMAT);
        this.aliases.put("CASE SENSITIVE", DEFAULT_UNIT_FORMAT);
        this.aliases.put("CI", UCUMFormat.Variant.CASE_INSENSITIVE.name());
        this.aliases.put("C/I", UCUMFormat.Variant.CASE_INSENSITIVE.name());
        this.aliases.put("CASE INSENSITIVE", DEFAULT_UNIT_FORMAT);
    }

    public UnitFormat getUnitFormat(String key) {
        Objects.requireNonNull(key, "Format name or alias required");
        String alias = this.aliases.get(key.toUpperCase());
        if (alias != null && alias.length() > 0) {
            return this.unitFormats.get(alias);
        }
        return this.unitFormats.get(key.toUpperCase());
    }

    public UnitFormat getUnitFormat() {
        return this.getUnitFormat(DEFAULT_UNIT_FORMAT);
    }

    public Set<String> getAvailableFormatNames() {
        return this.unitFormats.keySet();
    }

    public QuantityFormat getQuantityFormat(String name) {
        return this.quantityFormats.get(name);
    }

    public QuantityFormat getQuantityFormat() {
        return this.getQuantityFormat(DEFAULT_QUANTITY_FORMAT);
    }

    public Set<String> getAvailableFormatNames(FormatService.FormatType type) {
        switch (type) {
            case QUANTITY_FORMAT: {
                return this.quantityFormats.keySet();
            }
        }
        return this.unitFormats.keySet();
    }
}

