/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import si.uom.SI;
import systems.uom.ucum.format.UCUMConverterFormatter;
import systems.uom.ucum.internal.format.UCUMFormatParser;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.AbstractUnitFormat;
import tech.units.indriya.format.SymbolMap;
import tech.units.indriya.function.PowersOfIntConverter;
import tech.units.indriya.internal.format.TokenException;
import tech.units.indriya.internal.format.TokenMgrError;
import tech.units.indriya.unit.AnnotatedUnit;
import tech.units.indriya.unit.MetricPrefix;
import tech.units.indriya.unit.Prefix;
import tech.units.indriya.unit.TransformedUnit;

public abstract class UCUMFormat
extends AbstractUnitFormat {
    private static final String BUNDLE_BASE = UCUMFormat.class.getName();
    final SymbolMap symbolMap;

    public static UCUMFormat getInstance(Variant variant) {
        switch (variant) {
            case CASE_INSENSITIVE: {
                return Parsing.DEFAULT_CI;
            }
            case CASE_SENSITIVE: {
                return Parsing.DEFAULT_CS;
            }
            case PRINT: {
                return Print.DEFAULT;
            }
        }
        throw new IllegalArgumentException("Unknown variant: " + (Object)((Object)variant));
    }

    public static UCUMFormat getInstance(Variant variant, SymbolMap symbolMap) {
        switch (variant) {
            case CASE_INSENSITIVE: {
                return new Parsing(symbolMap, false);
            }
            case CASE_SENSITIVE: {
                return new Parsing(symbolMap, true);
            }
            case PRINT: {
                return new Print(symbolMap);
            }
        }
        throw new IllegalArgumentException("Unknown variant: " + (Object)((Object)variant));
    }

    protected SymbolMap getSymbols() {
        return this.symbolMap;
    }

    UCUMFormat(SymbolMap symbolMap) {
        this.symbolMap = symbolMap;
    }

    public abstract Unit<? extends Quantity<?>> parse(CharSequence var1, ParsePosition var2) throws ParserException;

    protected Unit<?> parse(CharSequence csq, int index) throws ParserException {
        return this.parse(csq, new ParsePosition(index));
    }

    public abstract Unit<? extends Quantity<?>> parse(CharSequence var1) throws ParserException;

    public Appendable format(Unit<?> unknownUnit, Appendable appendable) throws IOException {
        CharSequence symbol;
        String mapSymbol;
        if (!(unknownUnit instanceof AbstractUnit)) {
            throw new UnsupportedOperationException("The UCUM format supports only known units (AbstractUnit instances)");
        }
        AbstractUnit unit = (AbstractUnit)unknownUnit;
        String annotation = null;
        if (unit instanceof AnnotatedUnit) {
            AnnotatedUnit annotatedUnit = (AnnotatedUnit)unit;
            unit = annotatedUnit.getActualUnit();
            annotation = annotatedUnit.getAnnotation();
        }
        if ((mapSymbol = this.symbolMap.getSymbol((Unit)unit)) != null) {
            symbol = mapSymbol;
        } else if (unit instanceof TransformedUnit) {
            StringBuilder temp = new StringBuilder();
            Unit parentUnit = ((TransformedUnit)unit).getParentUnit();
            UnitConverter converter = unit.getConverterTo(parentUnit);
            boolean printSeparator = !parentUnit.equals(AbstractUnit.ONE);
            this.format(parentUnit, temp);
            UCUMConverterFormatter.formatConverter(converter, printSeparator, temp, this.symbolMap);
            symbol = temp;
        } else if (unit.getBaseUnits() != null) {
            Map productUnits = unit.getBaseUnits();
            StringBuffer app = new StringBuffer();
            LinkedHashMap numeratorUnits = new LinkedHashMap();
            LinkedHashMap denominatorUnits = new LinkedHashMap();
            for (Map.Entry u : productUnits.entrySet()) {
                if ((Integer)u.getValue() > 0) {
                    numeratorUnits.put(u.getKey(), u.getValue());
                    continue;
                }
                denominatorUnits.put(u.getKey(), u.getValue());
            }
            int numeratorCount = 1;
            for (Map.Entry entry : numeratorUnits.entrySet()) {
                if (numeratorCount > 1) {
                    app.append(".");
                }
                this.format((Unit)entry.getKey(), app);
                if ((Integer)entry.getValue() > 1) {
                    app.append(entry.getValue());
                }
                ++numeratorCount;
            }
            if (numeratorCount == 1) {
                app.append("1");
            }
            if (denominatorUnits.size() > 0) {
                app.append("/");
                int denominatorCount = 1;
                for (Map.Entry u : denominatorUnits.entrySet()) {
                    if (denominatorCount == 1 && denominatorUnits.size() > 1) {
                        app.append("(");
                    }
                    if (denominatorCount > 1) {
                        app.append(".");
                    }
                    this.format((Unit)u.getKey(), app);
                    if (Math.abs((Integer)u.getValue()) < -1) {
                        app.append(-((Integer)u.getValue()).intValue());
                    }
                    if (denominatorCount == denominatorUnits.size() && denominatorUnits.size() > 1) {
                        app.append(")");
                    }
                    ++denominatorCount;
                }
            }
            symbol = app;
        } else if (!unit.isSystemUnit() || unit.equals((Object)SI.KILOGRAM)) {
            boolean printSeparator;
            UnitConverter converter;
            StringBuilder temp = new StringBuilder();
            if (unit.equals((Object)SI.KILOGRAM)) {
                this.format(SI.GRAM, temp);
                converter = PowersOfIntConverter.of((Prefix)MetricPrefix.KILO);
                printSeparator = true;
            } else {
                Unit parentUnit = unit.getSystemUnit();
                converter = unit.getConverterTo(parentUnit);
                if (parentUnit.equals(SI.KILOGRAM)) {
                    parentUnit = SI.GRAM;
                    converter = converter.concatenate((UnitConverter)PowersOfIntConverter.of((Prefix)MetricPrefix.KILO));
                }
                this.format(parentUnit, temp);
                printSeparator = !parentUnit.equals(AbstractUnit.ONE);
            }
            UCUMConverterFormatter.formatConverter(converter, printSeparator, temp, this.symbolMap);
            symbol = temp;
        } else if (unit.getSymbol() != null) {
            symbol = unit.getSymbol();
        } else {
            throw new IllegalArgumentException("Cannot format the given Object as UCUM units (unsupported unit " + unit.getClass().getName() + "). Custom units types should override the toString() method as the default implementation uses the UCUM format.");
        }
        appendable.append(symbol);
        if (annotation != null && annotation.length() > 0) {
            this.appendAnnotation(symbol, annotation, appendable);
        }
        return appendable;
    }

    public void label(Unit<?> unit, String label) {
        throw new UnsupportedOperationException("label() not supported by this implementation");
    }

    public boolean isLocaleSensitive() {
        return false;
    }

    void appendAnnotation(CharSequence symbol, CharSequence annotation, Appendable appendable) throws IOException {
        appendable.append('{');
        appendable.append(annotation);
        appendable.append('}');
    }

    static /* synthetic */ String access$300() {
        return BUNDLE_BASE;
    }

    private static final class Parsing
    extends UCUMFormat {
        private static final SymbolMap CASE_SENSITIVE_SYMBOLS = SymbolMap.of((ResourceBundle)ResourceBundle.getBundle(UCUMFormat.access$300() + "_CS", new ResourceBundle.Control(){

            @Override
            public List<Locale> getCandidateLocales(String baseName, Locale locale) {
                if (baseName == null) {
                    throw new NullPointerException();
                }
                if (locale.equals(new Locale("", "CS"))) {
                    return Arrays.asList(locale, Locale.ROOT);
                }
                return super.getCandidateLocales(baseName, locale);
            }
        }));
        private static final SymbolMap CASE_INSENSITIVE_SYMBOLS = SymbolMap.of((ResourceBundle)ResourceBundle.getBundle(UCUMFormat.access$300() + "_CI", new ResourceBundle.Control(){

            @Override
            public List<Locale> getCandidateLocales(String baseName, Locale locale) {
                if (baseName == null) {
                    throw new NullPointerException();
                }
                if (locale.equals(new Locale("", "CI"))) {
                    return Arrays.asList(locale, Locale.ROOT);
                }
                if (locale.equals(Locale.GERMANY)) {
                    return Arrays.asList(locale, Locale.ROOT);
                }
                return super.getCandidateLocales(baseName, locale);
            }
        }));
        private static final Parsing DEFAULT_CS = new Parsing(CASE_SENSITIVE_SYMBOLS, true);
        private static final Parsing DEFAULT_CI = new Parsing(CASE_INSENSITIVE_SYMBOLS, false);
        private final boolean caseSensitive;

        public Parsing(SymbolMap symbols, boolean caseSensitive) {
            super(symbols);
            this.caseSensitive = caseSensitive;
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq, ParsePosition cursor) throws ParserException {
            int start = cursor.getIndex();
            int end = csq.length();
            if (end <= start) {
                return AbstractUnit.ONE;
            }
            String source = csq.subSequence(start, end).toString().trim();
            if (source.length() == 0) {
                return AbstractUnit.ONE;
            }
            if (!this.caseSensitive) {
                source = source.toUpperCase();
            }
            UCUMFormatParser parser = new UCUMFormatParser(this.symbolMap, new ByteArrayInputStream(source.getBytes()));
            try {
                Unit result = parser.parseUnit();
                cursor.setIndex(end);
                return result;
            }
            catch (TokenException e) {
                if (e.currentToken != null) {
                    cursor.setErrorIndex(start + e.currentToken.endColumn);
                } else {
                    cursor.setErrorIndex(start);
                }
                throw new ParserException((Throwable)e);
            }
            catch (TokenMgrError e) {
                cursor.setErrorIndex(start);
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq) throws ParserException {
            return this.parse(csq, new ParsePosition(0));
        }
    }

    private static final class Print
    extends UCUMFormat {
        private static final SymbolMap PRINT_SYMBOLS = SymbolMap.of((ResourceBundle)ResourceBundle.getBundle(UCUMFormat.access$300() + "_Print"));
        private static final Print DEFAULT = new Print(PRINT_SYMBOLS);

        public Print(SymbolMap symbols) {
            super(symbols);
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq, ParsePosition pos) throws IllegalArgumentException {
            throw new UnsupportedOperationException("The print format is for pretty-printing of units only. Parsing is not supported.");
        }

        @Override
        void appendAnnotation(CharSequence symbol, CharSequence annotation, Appendable appendable) throws IOException {
            if (symbol != null && symbol.length() > 0) {
                appendable.append('(');
                appendable.append(annotation);
                appendable.append(')');
            } else {
                appendable.append(annotation);
            }
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq) throws IllegalArgumentException {
            return this.parse(csq, new ParsePosition(0));
        }
    }

    public static enum Variant {
        CASE_SENSITIVE,
        CASE_INSENSITIVE,
        PRINT;

    }
}

