/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import systems.uom.ucum.format.UCUMFormat;
import systems.uom.ucum.format.UCUMFormatTestBase;
import systems.uom.ucum.internal.format.TokenException;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.LocalUnitFormat;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.Units;

public class UCUMFormatTable2Test
extends UCUMFormatTestBase {
    private Quantity<Length> sut;

    @Before
    public void init() {
        this.sut = Quantities.getQuantity((Number)10, (Unit)UCUM.METER);
    }

    @Test
    public void testFormatLocal() {
        LocalUnitFormat format = LocalUnitFormat.getInstance();
        Assert.assertEquals((Object)UCUM.METER, (Object)this.sut.getUnit());
        Assert.assertEquals((Object)"m", (Object)format.format(UCUM.METER));
        ProductUnit v = new ProductUnit(UCUM.METER.divide(UCUM.SECOND));
        Assert.assertEquals((Object)"m/s", (Object)format.format((Unit)v));
    }

    @Test
    public void testFormatUCUMPrint() {
        Assert.assertEquals((Object)UCUM.METER, (Object)this.sut.getUnit());
        Assert.assertEquals((String)"the formatter isn't working with a unit which there's a specific symbol on the symbolMap for it", (Object)"m", (Object)FORMAT_PRINT.format(UCUM.METER));
        ProductUnit v = new ProductUnit(this.sut.getUnit().divide(UCUM.SECOND));
        Assert.assertEquals((String)"the formatter isn't working with a product unit", (Object)"m/s", (Object)FORMAT_PRINT.format((Unit)v));
    }

    @Test
    public void testFormatUCUMCS() {
        Assert.assertEquals((Object)UCUM.METER, (Object)this.sut.getUnit());
        Assert.assertEquals((String)"the formatter isn't working with a unit which there's a specific symbol on the symbolMap for it", (Object)"m", (Object)FORMAT_CS.format(UCUM.METER));
        ProductUnit v = new ProductUnit(UCUM.METER.divide(UCUM.SECOND));
        Assert.assertEquals((String)"the formatter isn't working with a product unit", (Object)"m/s", (Object)FORMAT_CS.format((Unit)v));
    }

    @Test
    public void testFormatUCUMCI() {
        Assert.assertEquals((Object)UCUM.METER, (Object)this.sut.getUnit());
        Assert.assertEquals((String)"the formatter isn't working with a unit which there's a specific symbol on the symbolMap for it", (Object)"M", (Object)FORMAT_CI.format(UCUM.METER));
        ProductUnit v = new ProductUnit(UCUM.METER.divide(UCUM.SECOND));
        Assert.assertEquals((String)"the formatter isn't working with a product unit", (Object)"M/S", (Object)FORMAT_CI.format((Unit)v));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testParseLocal() {
        LocalUnitFormat format = LocalUnitFormat.getInstance();
        format.parse((CharSequence)"min").getSymbol();
    }

    @Test
    public void testParseUCUMCS() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
        Assert.assertEquals((Object)UCUM.MINUTE, (Object)format.parse((CharSequence)"min"));
    }

    @Test
    public void testParseUCUMCI() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_INSENSITIVE);
        Assert.assertEquals((Object)UCUM.METER, (Object)format.parse((CharSequence)"M"));
    }

    @Test(expected=TokenException.class)
    public void testParseUCUMCSError() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
        format.parse((CharSequence)"MIN");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testParseUCUMPrint() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.PRINT);
        format.parse((CharSequence)"g");
    }

    @Test
    public void testParseUCUMCITemperatureInverse() throws Exception {
        Unit parsedUnit = FORMAT_CI.parse((CharSequence)"1/K");
        Assert.assertEquals((String)"The Unit<Temperature> in  parsed string doesn't match", (Object)AbstractUnit.ONE.divide(Units.KELVIN), (Object)parsedUnit);
    }

    @Test
    public void testParseUCUMCSTemperatureInverse() throws Exception {
        Unit parsedUnit = FORMAT_CS.parse((CharSequence)"1/K");
        Assert.assertEquals((String)"The Unit<Temperature> in  parsed string doesn't match", (Object)AbstractUnit.ONE.divide(Units.KELVIN), (Object)parsedUnit);
    }
}

