/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.junit.Assert;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import systems.uom.ucum.format.UCUMFormatTestBase;
import tech.units.indriya.function.PowersOfIntConverter;
import tech.units.indriya.unit.MetricPrefix;

public class PrefixTest
extends UCUMFormatTestBase {
    @Test
    public void testKilo() {
        Unit m1 = MetricPrefix.KILO((Unit)UCUM.GRAM);
        Assert.assertEquals((Object)"g.1000", (Object)FORMAT_PRINT.format(m1));
    }

    @Test
    public void testMega() {
        Unit m1 = MetricPrefix.MEGA((Unit)UCUM.GRAM);
        Assert.assertEquals((Object)"t", (Object)FORMAT_PRINT.format(UCUM.TONNE));
        Assert.assertEquals((Object)"g.1000000", (Object)FORMAT_PRINT.format(m1));
    }

    @Test
    public void testMega2() {
        Unit m1 = MetricPrefix.MEGA((Unit)UCUM.TONNE);
        Assert.assertEquals((Object)"t.1000000", (Object)FORMAT_PRINT.format(m1));
    }

    @Test
    public void testNano() {
        Unit m1 = MetricPrefix.NANO((Unit)UCUM.GRAM);
        Assert.assertEquals((Object)"g/1000000000", (Object)FORMAT_PRINT.format(m1));
    }

    @Test
    public void testBetweenPrefixes() {
        UnitConverter conv = MetricPrefix.YOTTA((Unit)UCUM.METER).getConverterTo(MetricPrefix.ZETTA((Unit)UCUM.METER));
        Assert.assertEquals((Object)PowersOfIntConverter.of((int)10, (int)3), (Object)conv);
    }

    @Test
    public void testBetweenPrefixes2() {
        UnitConverter conv = MetricPrefix.KILO((Unit)UCUM.METER).getConverterTo(MetricPrefix.GIGA((Unit)UCUM.METER));
        Assert.assertEquals((Object)PowersOfIntConverter.of((int)10, (int)-6), (Object)conv);
    }
}

