/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum;

import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.junit.Assert;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.Quantities;

public class UCUMTest {
    @Test
    public void testLiterToDm3() {
        ComparableQuantity oneLiter = Quantities.getQuantity((Number)1, (Unit)UCUM.LITER);
        ComparableQuantity oneDm3 = Quantities.getQuantity((Number)1, (Unit)UCUM.LITER_DM3);
        Assert.assertEquals((Object)1, (Object)oneLiter.to(UCUM.LITER_DM3).getValue());
    }

    @Test
    public void testUnitNotEqualsLiters() {
        Assert.assertNotEquals((Object)UCUM.LITER, (Object)UCUM.LITER_DM3);
    }

    @Test
    public void testNameEqualsLiters() {
        Assert.assertEquals((Object)UCUM.LITER.getName(), (Object)UCUM.LITER_DM3.getName());
    }

    @Test
    public void testConvEqualsLiters() {
        UnitConverter c1 = UCUM.LITER.getConverterTo(UCUM.LITER_DM3);
        UnitConverter c2 = UCUM.LITER_DM3.getConverterTo(UCUM.LITER);
        Assert.assertEquals((Object)c1, (Object)c2);
    }

    @Test
    public void testStToDm3() {
        ComparableQuantity oneLiter = Quantities.getQuantity((Number)1, (Unit)UCUM.STERE);
        Assert.assertEquals((Object)1000.0, (Object)oneLiter.to(UCUM.LITER_DM3).getValue());
    }

    @Test
    public void testStToLiter() {
        ComparableQuantity oneLiter = Quantities.getQuantity((Number)1, (Unit)UCUM.STERE);
        Assert.assertEquals((Object)1000.0, (Object)oneLiter.to(UCUM.LITER).getValue());
    }
}

