/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import javax.measure.Unit;
import org.junit.Assert;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import systems.uom.ucum.format.UCUMFormat;
import systems.uom.ucum.format.UCUMFormatTestBase;
import tec.uom.se.unit.MetricPrefix;

public class UCUMFormatTable4Test
extends UCUMFormatTestBase {
    @Test
    public void testFormatUCUMCSWithNegativePrefix() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
        Unit hertzSubmultiple = MetricPrefix.DECI((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The DECI prefix didn't work", (Object)"dHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.CENTI((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The CENTI prefix didn't work", (Object)"cHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.MILLI((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The MILLI prefix didn't work", (Object)"mHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.MICRO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The MICRO prefix didn't work", (Object)"uHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.NANO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The NANO prefix didn't work", (Object)"nHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.PICO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The PICO prefix didn't work", (Object)"pHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.FEMTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The FEMTO prefix didn't work", (Object)"fHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.ATTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The ATTO prefix didn't work", (Object)"aHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.ZEPTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The ZEPTO prefix didn't work", (Object)"zHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.YOCTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The YOCTO prefix didn't work", (Object)"yHz", (Object)format.format(hertzSubmultiple));
        Assert.assertEquals((String)"The MILLI prefix didn't work with a product unit", (Object)"mm/s", (Object)format.format(MetricPrefix.MILLI((Unit)UCUM.METER).divide(UCUM.SECOND)));
    }

    @Test
    public void testFormatUCUMCSWithPositivePrefix() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
        Unit hertzMultiple = MetricPrefix.DEKA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The DEKA prefix didn't work", (Object)"daHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.HECTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The HECTO prefix didn't work", (Object)"hHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.KILO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The KILO prefix didn't work", (Object)"kHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.MEGA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The MEGA prefix didn't work", (Object)"MHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.GIGA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The GIGA prefix didn't work", (Object)"GHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.TERA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The TERA prefix didn't work", (Object)"THz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.PETA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The PETA prefix didn't work", (Object)"PHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.EXA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The EXA prefix didn't work", (Object)"EHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.ZETTA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The ZETTA prefix didn't work", (Object)"ZHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.YOTTA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The YOTTA prefix didn't work", (Object)"YHz", (Object)format.format(hertzMultiple));
        Assert.assertEquals((String)"The KILO prefix didn't work with a product unit", (Object)"km/s", (Object)format.format(MetricPrefix.KILO((Unit)UCUM.METER).divide(UCUM.SECOND)));
    }

    @Test
    public void testFormatUCUMCIWithNegativePrefix() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_INSENSITIVE);
        Unit hertzSubmultiple = MetricPrefix.DECI((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The DECI prefix didn't work", (Object)"DHZ", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.CENTI((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The CENTI prefix didn't work", (Object)"CHZ", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.MILLI((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The MILLI prefix didn't work", (Object)"MHZ", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.MICRO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The MICRO prefix didn't work", (Object)"UHZ", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.NANO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The NANO prefix didn't work", (Object)"NHZ", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.PICO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The PICO prefix didn't work", (Object)"PHZ", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.FEMTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The FEMTO prefix didn't work", (Object)"FHZ", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.ATTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The ATTO prefix didn't work", (Object)"AHZ", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.ZEPTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The ZEPTO prefix didn't work", (Object)"ZOHZ", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.YOCTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The YOCTO prefix didn't work", (Object)"YOHZ", (Object)format.format(hertzSubmultiple));
        Assert.assertEquals((String)"The MILLI prefix didn't work with a product unit", (Object)"MM/S", (Object)format.format(MetricPrefix.MILLI((Unit)UCUM.METER).divide(UCUM.SECOND)));
    }

    @Test
    public void testFormatUCUMCIWithPositivePrefix() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_INSENSITIVE);
        Unit hertzMultiple = MetricPrefix.DEKA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The DEKA prefix didn't work", (Object)"DAHZ", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.HECTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The HECTO prefix didn't work", (Object)"HHZ", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.KILO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The KILO prefix didn't work", (Object)"KHZ", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.MEGA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The MEGA prefix didn't work", (Object)"MAHZ", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.GIGA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The GIGA prefix didn't work", (Object)"GAHZ", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.TERA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The TERA prefix didn't work", (Object)"TRHZ", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.PETA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The PETA prefix didn't work", (Object)"PTHZ", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.EXA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The EXA prefix didn't work", (Object)"EXHZ", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.ZETTA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The ZETTA prefix didn't work", (Object)"ZAHZ", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.YOTTA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The YOTTA prefix didn't work", (Object)"YAHZ", (Object)format.format(hertzMultiple));
        Assert.assertEquals((String)"The KILO prefix didn't work with a product unit", (Object)"KM/S", (Object)format.format(MetricPrefix.KILO((Unit)UCUM.METER).divide(UCUM.SECOND)));
    }

    @Test
    public void testParseUCUMCSWithNegativePrefix() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
        Assert.assertEquals((String)"The DECI prefix didn't work", (Object)MetricPrefix.DECI((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"dHz"));
        Assert.assertEquals((String)"The CENTI prefix didn't work", (Object)MetricPrefix.CENTI((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"cHz"));
        Assert.assertEquals((String)"The MILLI prefix didn't work", (Object)MetricPrefix.MILLI((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"mHz"));
        Assert.assertEquals((String)"The MICRO prefix didn't work", (Object)MetricPrefix.MICRO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"uHz"));
        Assert.assertEquals((String)"The NANO prefix didn't work", (Object)MetricPrefix.NANO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"nHz"));
        Assert.assertEquals((String)"The PICO prefix didn't work", (Object)MetricPrefix.PICO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"pHz"));
        Assert.assertEquals((String)"The FEMTO prefix didn't work", (Object)MetricPrefix.FEMTO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"fHz"));
        Assert.assertEquals((String)"The ATTO prefix didn't work", (Object)MetricPrefix.ATTO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"aHz"));
        Assert.assertEquals((String)"The ZEPTO prefix didn't work", (Object)MetricPrefix.ZEPTO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"zHz"));
        Assert.assertEquals((String)"The YOCTO prefix didn't work", (Object)MetricPrefix.YOCTO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"yHz"));
        Assert.assertEquals((String)"The MILLI prefix didn't work with a product unit", (Object)MetricPrefix.MILLI((Unit)UCUM.METER).divide(UCUM.SECOND), (Object)format.parse((CharSequence)"mm/s"));
    }

    @Test
    public void testParseUCUMCSWithPositivePrefix() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
        Assert.assertEquals((String)"The DEKA prefix didn't work", (Object)MetricPrefix.DEKA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"daHz"));
        Assert.assertEquals((String)"The HECTO prefix didn't work", (Object)MetricPrefix.HECTO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"hHz"));
        Assert.assertEquals((String)"The KILO prefix didn't work", (Object)MetricPrefix.KILO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"kHz"));
        Assert.assertEquals((String)"The MEGA prefix didn't work", (Object)MetricPrefix.MEGA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"MHz"));
        Assert.assertEquals((String)"The GIGA prefix didn't work", (Object)MetricPrefix.GIGA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"GHz"));
        Assert.assertEquals((String)"The TERA prefix didn't work", (Object)MetricPrefix.TERA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"THz"));
        Assert.assertEquals((String)"The PETA prefix didn't work", (Object)MetricPrefix.PETA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"PHz"));
        Assert.assertEquals((String)"The EXA prefix didn't work", (Object)MetricPrefix.EXA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"EHz"));
        Assert.assertEquals((String)"The ZETTA prefix didn't work", (Object)MetricPrefix.ZETTA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"ZHz"));
        Assert.assertEquals((String)"The YOTTA prefix didn't work", (Object)MetricPrefix.YOTTA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"YHz"));
        Assert.assertEquals((String)"The KILO prefix didn't work with a product unit", (Object)MetricPrefix.KILO((Unit)UCUM.METER).divide(UCUM.SECOND), (Object)format.parse((CharSequence)"km/s"));
    }

    @Test
    public void testParseUCUMCIWithNegativePrefix() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_INSENSITIVE);
        Assert.assertEquals((String)"The DECI prefix didn't work", (Object)MetricPrefix.DECI((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"DHz"));
        Assert.assertEquals((String)"The CENTI prefix didn't work", (Object)MetricPrefix.CENTI((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"CHz"));
        Assert.assertEquals((String)"The MILLI prefix didn't work", (Object)MetricPrefix.MILLI((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"MHz"));
        Assert.assertEquals((String)"The MICRO prefix didn't work", (Object)MetricPrefix.MICRO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"UHz"));
        Assert.assertEquals((String)"The NANO prefix didn't work", (Object)MetricPrefix.NANO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"NHz"));
        Assert.assertEquals((String)"The PICO prefix didn't work", (Object)MetricPrefix.PICO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"PHz"));
        Assert.assertEquals((String)"The FEMTO prefix didn't work", (Object)MetricPrefix.FEMTO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"FHz"));
        Assert.assertEquals((String)"The ATTO prefix didn't work", (Object)MetricPrefix.ATTO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"AHz"));
        Assert.assertEquals((String)"The ZEPTO prefix didn't work", (Object)MetricPrefix.ZEPTO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"ZOHz"));
        Assert.assertEquals((String)"The YOCTO prefix didn't work", (Object)MetricPrefix.YOCTO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"YOHz"));
        Assert.assertEquals((String)"The MILLI prefix didn't work with a product unit", (Object)MetricPrefix.MILLI((Unit)UCUM.METER).divide(UCUM.SECOND), (Object)format.parse((CharSequence)"MM/S"));
    }

    @Test
    public void testParseUCUMCIWithPositivePrefix() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_INSENSITIVE);
        Assert.assertEquals((String)"The DEKA prefix didn't work", (Object)MetricPrefix.DEKA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"DAHz"));
        Assert.assertEquals((String)"The HECTO prefix didn't work", (Object)MetricPrefix.HECTO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"HHz"));
        Assert.assertEquals((String)"The KILO prefix didn't work", (Object)MetricPrefix.KILO((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"KHz"));
        Assert.assertEquals((String)"The MEGA prefix didn't work", (Object)MetricPrefix.MEGA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"MAHz"));
        Assert.assertEquals((String)"The GIGA prefix didn't work", (Object)MetricPrefix.GIGA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"GAHz"));
        Assert.assertEquals((String)"The TERA prefix didn't work", (Object)MetricPrefix.TERA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"TRHz"));
        Assert.assertEquals((String)"The PETA prefix didn't work", (Object)MetricPrefix.PETA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"PTHz"));
        Assert.assertEquals((String)"The EXA prefix didn't work", (Object)MetricPrefix.EXA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"EXHz"));
        Assert.assertEquals((String)"The ZETTA prefix didn't work", (Object)MetricPrefix.ZETTA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"ZAHz"));
        Assert.assertEquals((String)"The YOTTA prefix didn't work", (Object)MetricPrefix.YOTTA((Unit)UCUM.HERTZ), (Object)format.parse((CharSequence)"YAHz"));
        Assert.assertEquals((String)"The KILO prefix didn't work with a product unit", (Object)MetricPrefix.KILO((Unit)UCUM.METER).divide(UCUM.SECOND), (Object)format.parse((CharSequence)"KM/S"));
    }

    @Test
    public void testFormatUCUMPrintWithNegativePrefix() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.PRINT);
        Unit hertzSubmultiple = MetricPrefix.DECI((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The DECI prefix didn't work", (Object)"dHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.CENTI((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The CENTI prefix didn't work", (Object)"cHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.MILLI((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The MILLI prefix didn't work", (Object)"mHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.MICRO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The MICRO prefix didn't work", (Object)"\u00b5Hz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.NANO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The NANO prefix didn't work", (Object)"nHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.PICO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The PICO prefix didn't work", (Object)"pHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.FEMTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The FEMTO prefix didn't work", (Object)"fHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.ATTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The ATTO prefix didn't work", (Object)"aHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.ZEPTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The ZEPTO prefix didn't work", (Object)"zHz", (Object)format.format(hertzSubmultiple));
        hertzSubmultiple = MetricPrefix.YOCTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The YOCTO prefix didn't work", (Object)"yHz", (Object)format.format(hertzSubmultiple));
        Assert.assertEquals((String)"The MILLI prefix didn't work with a product unit", (Object)"mm/s", (Object)format.format(MetricPrefix.MILLI((Unit)UCUM.METER).divide(UCUM.SECOND)));
    }

    @Test
    public void testFormatUCUMPrintWithPositivePrefix() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.PRINT);
        Unit hertzMultiple = MetricPrefix.DEKA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The DEKA prefix didn't work", (Object)"daHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.HECTO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The HECTO prefix didn't work", (Object)"hHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.KILO((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The KILO prefix didn't work", (Object)"kHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.MEGA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The MEGA prefix didn't work", (Object)"MHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.GIGA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The GIGA prefix didn't work", (Object)"GHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.TERA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The TERA prefix didn't work", (Object)"THz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.PETA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The PETA prefix didn't work", (Object)"PHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.EXA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The EXA prefix didn't work", (Object)"EHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.ZETTA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The ZETTA prefix didn't work", (Object)"ZHz", (Object)format.format(hertzMultiple));
        hertzMultiple = MetricPrefix.YOTTA((Unit)UCUM.HERTZ);
        Assert.assertEquals((String)"The YOTTA prefix didn't work", (Object)"YHz", (Object)format.format(hertzMultiple));
        Assert.assertEquals((String)"The KILO prefix didn't work with a product unit", (Object)"km/s", (Object)format.format(MetricPrefix.KILO((Unit)UCUM.METER).divide(UCUM.SECOND)));
    }
}

