/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import javax.measure.Unit;
import javax.measure.format.UnitFormat;
import javax.measure.spi.ServiceProvider;
import org.junit.Assert;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import systems.uom.ucum.format.UCUMFormatTestBase;
import systems.uom.ucum.internal.format.TokenException;
import tec.uom.se.unit.MetricPrefix;

public class UCUMFormatVolumeTest
extends UCUMFormatTestBase {
    @Test
    public void testFormatUCUMCI() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CI");
        Assert.assertEquals((Object)"L", (Object)unitFormat.format(UCUM.LITER_DM3));
    }

    @Test
    public void testFormatUCUMCS() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CS");
        Assert.assertEquals((Object)"l", (Object)unitFormat.format(UCUM.LITER_DM3));
    }

    @Test
    public void testFormatUCUMCIDeciDm3() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CI");
        Unit deciliter = MetricPrefix.DECI((Unit)UCUM.LITER_DM3);
        Assert.assertEquals((Object)"DL", (Object)unitFormat.format(deciliter));
    }

    @Test
    public void testFormatUCUMCSDeciDm3() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CS");
        Unit deciliter = MetricPrefix.DECI((Unit)UCUM.LITER_DM3);
        Assert.assertEquals((Object)"dl", (Object)unitFormat.format(deciliter));
    }

    @Test
    public void testParseUCUMCIDeciDm3() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CI");
        Unit deciliter2 = unitFormat.parse((CharSequence)"dl");
        Assert.assertEquals((Object)MetricPrefix.DECI((Unit)UCUM.LITER_DM3), (Object)deciliter2);
    }

    @Test
    public void testParseUCUMCSDeciDm3() {
        UnitFormat unitFormat2 = ServiceProvider.current().getUnitFormatService().getUnitFormat("CS");
        Unit dl3 = unitFormat2.parse((CharSequence)"dl");
        Assert.assertEquals((Object)MetricPrefix.DECI((Unit)UCUM.LITER_DM3), (Object)dl3);
    }

    @Test
    public void testParseUCUMCSMicroDm3() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CS");
        Unit microliter = unitFormat.parse((CharSequence)"ul");
        Assert.assertEquals((Object)MetricPrefix.MICRO((Unit)UCUM.LITER_DM3), (Object)microliter);
    }

    @Test(expected=TokenException.class)
    public void testParseUCUMCSMicroFail() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CS");
        Unit microliter = unitFormat.parse((CharSequence)"UL");
        Assert.assertEquals((Object)MetricPrefix.MICRO((Unit)UCUM.LITER_DM3), (Object)microliter);
    }

    @Test
    public void testParseUCUMCIMicro() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CI");
        Unit microliter = unitFormat.parse((CharSequence)"UL");
        Assert.assertEquals((Object)MetricPrefix.MICRO((Unit)UCUM.LITER_DM3), (Object)microliter);
    }

    @Test
    public void testParseUCUMCSMicro() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CS");
        Unit microliter = unitFormat.parse((CharSequence)"uL");
        Assert.assertEquals((Object)MetricPrefix.MICRO((Unit)UCUM.LITER), (Object)microliter);
    }

    @Test
    public void testParseUCUMCIDeciSt() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CI");
        Unit dst = unitFormat.parse((CharSequence)"DSTR");
        Assert.assertEquals((Object)MetricPrefix.DECI((Unit)UCUM.STERE), (Object)dst);
    }

    @Test
    public void testParseUCUMCIMicroSt() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CI");
        Unit ust = unitFormat.parse((CharSequence)"USTR");
        Assert.assertEquals((Object)MetricPrefix.MICRO((Unit)UCUM.STERE), (Object)ust);
    }

    @Test
    public void testParseUCUMCSDeciSt() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CS");
        Unit dst = unitFormat.parse((CharSequence)"dst");
        Assert.assertEquals((Object)MetricPrefix.DECI((Unit)UCUM.STERE), (Object)dst);
    }

    @Test
    public void testParseUCUMCSMicroSt() {
        UnitFormat unitFormat = ServiceProvider.current().getUnitFormatService().getUnitFormat("CS");
        Unit ust = unitFormat.parse((CharSequence)"ust");
        Assert.assertEquals((Object)MetricPrefix.MICRO((Unit)UCUM.STERE), (Object)ust);
    }

    @Test
    public void testFormatUCUMCSGill() {
        Assert.assertEquals((Object)"[gil_br]", (Object)FORMAT_CS.format(UCUM.GILL_BRITISH));
    }

    @Test
    public void testFormatUCUMCSmGill() {
        Assert.assertEquals((Object)"m[gil_br]", (Object)FORMAT_CS.format(MetricPrefix.MILLI((Unit)UCUM.GILL_BRITISH)));
    }
}

