/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.internal;

import java.util.HashMap;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Volume;
import si.uom.quantity.Action;
import si.uom.quantity.DynamicViscosity;
import si.uom.quantity.ElectricPermittivity;
import si.uom.quantity.IonizingRadiation;
import si.uom.quantity.KinematicViscosity;
import si.uom.quantity.MagneticFieldStrength;
import si.uom.quantity.MagneticPermeability;
import si.uom.quantity.MagnetomotiveForce;
import si.uom.quantity.WaveNumber;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractUnit;
import tec.uom.se.function.LogConverter;
import tec.uom.se.function.MultiplyConverter;
import tec.uom.se.function.PiMultiplierConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;
import tec.uom.se.unit.Units;

public final class SI
extends Units {
    private static final SI INSTANCE = new SI();
    private final HashMap<Class<? extends Quantity>, AbstractUnit> quantityToUnit = new HashMap();
    public static final AlternateUnit<MagnetomotiveForce> AMPERE_TURN = SI.addUnit(new AlternateUnit((Unit)AMPERE, "At"), MagnetomotiveForce.class);
    public static final Unit<Acceleration> METRES_PER_SQUARE_SECOND = SI.addUnit(new ProductUnit(METRES_PER_SECOND.divide(SECOND)), Acceleration.class);
    public static final Unit<Action> JOULE_SECOND = SI.addUnit(new ProductUnit(JOULE.multiply(SECOND)), Action.class);
    public static final Unit<ElectricPermittivity> FARADS_PER_METRE = SI.addUnit(new ProductUnit(FARAD.divide(METRE)), ElectricPermittivity.class);
    public static final Unit<MagneticPermeability> NEWTONS_PER_SQUARE_AMPERE = SI.addUnit(new ProductUnit(NEWTON.divide(AMPERE.pow(2))), MagneticPermeability.class);
    public static final Unit<WaveNumber> RECIPROCAL_METRE = SI.addUnit(new ProductUnit(METRE.pow(-1)), WaveNumber.class);
    public static final Unit<DynamicViscosity> PASCAL_SECOND = SI.addUnit(new ProductUnit(PASCAL.multiply(SECOND)), DynamicViscosity.class);
    public static final Unit<KinematicViscosity> SQUARE_METRES_PER_SECOND = SI.addUnit(new ProductUnit(SQUARE_METRE.divide(SECOND)), KinematicViscosity.class);
    public static final Unit<MagneticFieldStrength> AMPERES_PER_METRE = SI.addUnit(new ProductUnit(AMPERE.divide(METRE)), MagneticFieldStrength.class);
    public static final Unit<IonizingRadiation> COULOMBS_PER_KILOGRAM = SI.addUnit(new ProductUnit(COULOMB.divide((AbstractUnit)KILOGRAM)), IonizingRadiation.class);
    public static final Unit<Angle> DEGREE_ANGLE = new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 180L)));
    public static final Unit<Angle> MINUTE_ANGLE = new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 10800L)));
    public static final Unit<Angle> SECOND_ANGLE = new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 648000L)));
    public static final Unit<Volume> LITRE = new TransformedUnit((Unit)CUBIC_METRE, (UnitConverter)new RationalConverter(1L, 1000L));
    public static final Unit<Mass> TONNE = new TransformedUnit((Unit)KILOGRAM, (UnitConverter)new RationalConverter(1000L, 1L));
    public static final Unit<Dimensionless> NEPER = new TransformedUnit(ONE, (UnitConverter)new LogConverter(Math.E).inverse());
    public static final Unit<Dimensionless> BEL = new TransformedUnit(ONE, (UnitConverter)new LogConverter(10.0).inverse());
    public static final Unit<Energy> ELECTRON_VOLT = new TransformedUnit((Unit)JOULE, (UnitConverter)new MultiplyConverter(1.602176487E-19));
    public static final Unit<Mass> UNIFIED_ATOMIC_MASS = new TransformedUnit((Unit)KILOGRAM, (UnitConverter)new MultiplyConverter(1.660538782E-27));
    public static final Unit<Length> ASTRONOMICAL_UNIT = SI.addUnit(new TransformedUnit(METRE, (UnitConverter)new MultiplyConverter(1.49597871E11)));
    public static final Unit<Angle> REVOLUTION = new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(2L, 1L)));
    public static final Unit<Area> HECTARE = new TransformedUnit(SQUARE_METRE, (UnitConverter)new RationalConverter(10000L, 1L));

    private SI() {
    }

    public static SI getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return "SI";
    }

    public <Q extends Quantity<Q>> AbstractUnit<Q> getUnit(Class<Q> quantityType) {
        return this.quantityToUnit.get(quantityType);
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        SI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        SI.INSTANCE.units.add(unit);
        SI.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }
}

