/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import java.io.IOException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import javax.measure.quantity.Length;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import systems.uom.ucum.format.UCUMFormat;
import tec.uom.se.format.LocalUnitFormat;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.Units;

public class UnitFormatTest {
    private Quantity<Length> sut;

    @Before
    public void init() {
        this.sut = Quantities.getQuantity((Number)10, (Unit)Units.METRE);
    }

    @Test
    public void testFormat() {
        AlternateUnit hz = Units.HERTZ;
        Assert.assertEquals((Object)"Hz", (Object)hz.toString());
    }

    @Test
    public void testFormat2() {
        Unit mhz = MetricPrefix.MEGA((Unit)Units.HERTZ);
        Assert.assertEquals((Object)"MHz", (Object)mhz.toString());
    }

    @Test
    public void testFormat3() {
        Unit khz = MetricPrefix.KILO((Unit)Units.HERTZ);
        Assert.assertEquals((Object)"kHz", (Object)khz.toString());
    }

    @Test
    public void testFormat4() {
        Unit kph = Units.KILOMETRES_PER_HOUR;
        Assert.assertEquals((Object)"kph", (Object)kph.toString());
    }

    @Test
    public void testFormatLocal() {
        LocalUnitFormat format = LocalUnitFormat.getInstance();
        StringBuilder a = new StringBuilder();
        try {
            format.format(Units.METRE, (Appendable)a);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)Units.METRE, (Object)this.sut.getUnit());
        Assert.assertEquals((Object)"m", (Object)((Object)a).toString());
        StringBuilder a2 = new StringBuilder();
        Unit v = UCUM.METER.divide(Units.SECOND);
        try {
            format.format(v, (Appendable)a2);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)"m/s", (Object)((Object)a2).toString());
    }

    @Test
    public void testFormatUCUMPrint() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.PRINT);
        StringBuilder a = new StringBuilder();
        try {
            format.format(Units.METRE, (Appendable)a);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)Units.METRE, (Object)this.sut.getUnit());
        Assert.assertEquals((Object)"m", (Object)((Object)a).toString());
        StringBuilder a2 = new StringBuilder();
        Unit v = this.sut.getUnit().divide(Units.SECOND);
        try {
            format.format(v, (Appendable)a2);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)"m/s", (Object)((Object)a2).toString());
    }

    @Test
    public void testFormatUCUMCS() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
        StringBuilder a = new StringBuilder();
        try {
            format.format(Units.METRE, (Appendable)a);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)Units.METRE, (Object)this.sut.getUnit());
        Assert.assertEquals((Object)"m", (Object)((Object)a).toString());
        StringBuilder a2 = new StringBuilder();
        Unit v = UCUM.METER.divide(Units.SECOND);
        try {
            format.format(v, (Appendable)a2);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)"m/s", (Object)((Object)a2).toString());
    }

    @Test
    public void testFormatUCUMCSfromQuantity() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
        StringBuilder a = new StringBuilder();
        try {
            format.format(Units.METRE, (Appendable)a);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)Units.METRE, (Object)this.sut.getUnit());
        Assert.assertEquals((Object)"m", (Object)((Object)a).toString());
        StringBuilder a2 = new StringBuilder();
        Unit v = this.sut.getUnit().divide(Units.SECOND);
        try {
            format.format(v, (Appendable)a2);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)"m/s", (Object)((Object)a2).toString());
    }

    @Test
    public void testFormatUCUMCI() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_INSENSITIVE);
        StringBuilder a = new StringBuilder();
        try {
            format.format(Units.METRE, (Appendable)a);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)Units.METRE, (Object)this.sut.getUnit());
        Assert.assertEquals((Object)"M", (Object)((Object)a).toString());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testParseLocal() {
        LocalUnitFormat format = LocalUnitFormat.getInstance();
        try {
            Unit u = format.parse((CharSequence)"min");
            Assert.assertEquals((Object)"min", (Object)u.getSymbol());
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseUCUMCS() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
        try {
            Unit u = format.parse((CharSequence)"min");
            Assert.assertEquals((Object)Units.MINUTE, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseUCUMCI() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_INSENSITIVE);
        try {
            Unit u = format.parse((CharSequence)"M");
            Assert.assertEquals((Object)Units.METRE, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testParseUCUMPrint() {
        UCUMFormat format = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.PRINT);
        try {
            Unit u = format.parse((CharSequence)"kg");
            Assert.assertEquals((Object)Units.KILOGRAM, (Object)u);
        }
        catch (ParserException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

