/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import systems.uom.ucum.internal.SI;
import systems.uom.ucum.internal.format.UCUMFormatParser;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractUnit;
import tec.uom.se.format.AbstractUnitFormat;
import tec.uom.se.format.SymbolMap;
import tec.uom.se.function.MultiplyConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.internal.format.TokenException;
import tec.uom.se.internal.format.TokenMgrError;
import tec.uom.se.unit.AnnotatedUnit;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.Units;

public abstract class UCUMFormat
extends AbstractUnitFormat {
    private static final String BUNDLE_BASE = UCUMFormat.class.getName();
    final SymbolMap symbolMap;

    public static UCUMFormat getInstance(Variant variant) {
        switch (variant) {
            case CASE_INSENSITIVE: {
                return Parsing.DEFAULT_CI;
            }
            case CASE_SENSITIVE: {
                return Parsing.DEFAULT_CS;
            }
            case PRINT: {
                return Print.DEFAULT;
            }
        }
        throw new IllegalArgumentException("Unknown variant: " + (Object)((Object)variant));
    }

    public static UCUMFormat getInstance(Variant variant, SymbolMap symbolMap) {
        switch (variant) {
            case CASE_INSENSITIVE: {
                return new Parsing(symbolMap, false);
            }
            case CASE_SENSITIVE: {
                return new Parsing(symbolMap, true);
            }
            case PRINT: {
                return new Print(symbolMap);
            }
        }
        throw new IllegalArgumentException("Unknown variant: " + (Object)((Object)variant));
    }

    protected SymbolMap getSymbols() {
        return this.symbolMap;
    }

    UCUMFormat(SymbolMap symbolMap) {
        this.symbolMap = symbolMap;
    }

    public abstract Unit<? extends Quantity<?>> parse(CharSequence var1, ParsePosition var2) throws ParserException;

    public abstract Unit<? extends Quantity<?>> parse(CharSequence var1) throws ParserException;

    public Appendable format(Unit<?> unknownUnit, Appendable appendable) throws IOException {
        CharSequence symbol;
        String mapSymbol;
        if (!(unknownUnit instanceof AbstractUnit)) {
            throw new UnsupportedOperationException("The UCUM format supports only known units (AbstractUnit instances)");
        }
        AbstractUnit unit = (AbstractUnit)unknownUnit;
        String annotation = null;
        if (unit instanceof AnnotatedUnit) {
            AnnotatedUnit annotatedUnit = (AnnotatedUnit)unit;
            unit = annotatedUnit.getActualUnit();
            annotation = annotatedUnit.getAnnotation();
        }
        if ((mapSymbol = this.symbolMap.getSymbol((Unit)unit)) != null) {
            symbol = mapSymbol;
        } else if (unit.getProductUnits() != null) {
            Map productUnits = unit.getProductUnits();
            StringBuffer app = new StringBuffer();
            for (AbstractUnit u : productUnits.keySet()) {
                StringBuffer temp = new StringBuffer();
                if ((temp = (StringBuffer)this.format((Unit<?>)u, temp)).indexOf(".") >= 0 || temp.indexOf("/") >= 0) {
                    temp.insert(0, '(');
                    temp.append(')');
                }
                int pow = (Integer)productUnits.get(u);
                if (app.length() > 0) {
                    if (pow >= 0) {
                        app.append('.');
                    } else {
                        app.append('/');
                        pow = -pow;
                    }
                } else if (pow < 0) {
                    app.append("1/");
                    pow = -pow;
                }
                app.append(temp);
                if (pow == 1) continue;
                app.append(Integer.toString(pow));
            }
            symbol = app;
        } else if (!unit.isSystemUnit() || unit.equals((Object)SI.KILOGRAM)) {
            boolean printSeparator;
            UnitConverter converter;
            StringBuilder temp = new StringBuilder();
            if (unit.equals((Object)SI.KILOGRAM)) {
                this.format(SI.GRAM, temp);
                converter = MetricPrefix.KILO.getConverter();
                printSeparator = true;
            } else {
                AbstractUnit parentUnit = unit.getSystemUnit();
                converter = unit.getConverterTo((Unit)parentUnit);
                if (parentUnit.equals(SI.KILOGRAM)) {
                    parentUnit = SI.GRAM;
                    converter = converter.concatenate(MetricPrefix.KILO.getConverter());
                }
                this.format((Unit<?>)parentUnit, temp);
                printSeparator = !parentUnit.equals(Units.ONE);
            }
            this.formatConverter(converter, printSeparator, temp);
            symbol = temp;
        } else if (unit.getSymbol() != null) {
            symbol = unit.getSymbol();
        } else {
            throw new IllegalArgumentException("Cannot format the given Object as UCUM units (unsupported unit " + unit.getClass().getName() + "). " + "Custom units types should override the toString() method as the default implementation uses the UCUM format.");
        }
        appendable.append(symbol);
        if (annotation != null && annotation.length() > 0) {
            this.appendAnnotation(symbol, annotation, appendable);
        }
        return appendable;
    }

    public void label(Unit<?> unit, String label) {
    }

    public boolean isLocaleSensitive() {
        return false;
    }

    void appendAnnotation(CharSequence symbol, CharSequence annotation, Appendable appendable) throws IOException {
        appendable.append('{');
        appendable.append(annotation);
        appendable.append('}');
    }

    void formatConverter(UnitConverter converter, boolean continued, StringBuilder buffer) {
        boolean unitIsExpression = buffer.indexOf(".") >= 0 || buffer.indexOf("/") >= 0;
        MetricPrefix prefix = this.symbolMap.getPrefix(converter);
        if (prefix != null && !unitIsExpression) {
            buffer.insert(0, this.symbolMap.getSymbol(prefix));
        } else if (converter != AbstractConverter.IDENTITY) {
            if (converter instanceof MultiplyConverter) {
                MultiplyConverter multiplyConverter;
                double factor;
                long lFactor;
                if (unitIsExpression) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                if ((double)(lFactor = (long)(factor = (multiplyConverter = (MultiplyConverter)converter).getFactor())) != factor || lFactor < -9007199254740992L || lFactor > 0x20000000000000L) {
                    throw new IllegalArgumentException("Only integer factors are supported in UCUM");
                }
                if (continued) {
                    buffer.append('.');
                }
                buffer.append(lFactor);
            } else if (converter instanceof RationalConverter) {
                RationalConverter rationalConverter;
                if (unitIsExpression) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                if (!(rationalConverter = (RationalConverter)converter).getDividend().equals(BigInteger.ONE)) {
                    if (continued) {
                        buffer.append('.');
                    }
                    buffer.append(rationalConverter.getDividend());
                }
                if (!rationalConverter.getDivisor().equals(BigInteger.ONE)) {
                    buffer.append('/');
                    buffer.append(rationalConverter.getDivisor());
                }
            } else {
                buffer.insert(0, converter.toString() + "(");
                buffer.append(")");
            }
        }
    }

    static /* synthetic */ String access$300() {
        return BUNDLE_BASE;
    }

    private static final class Parsing
    extends UCUMFormat {
        private static final SymbolMap CASE_SENSITIVE_SYMBOLS = SymbolMap.of((ResourceBundle)ResourceBundle.getBundle(UCUMFormat.access$300() + "_CS", new ResourceBundle.Control(){

            @Override
            public List<Locale> getCandidateLocales(String baseName, Locale locale) {
                if (baseName == null) {
                    throw new NullPointerException();
                }
                if (locale.equals(new Locale("", "CS"))) {
                    return Arrays.asList(locale, Locale.ROOT);
                }
                return super.getCandidateLocales(baseName, locale);
            }
        }));
        private static final SymbolMap CASE_INSENSITIVE_SYMBOLS = SymbolMap.of((ResourceBundle)ResourceBundle.getBundle(UCUMFormat.access$300() + "_CI", new ResourceBundle.Control(){

            @Override
            public List<Locale> getCandidateLocales(String baseName, Locale locale) {
                if (baseName == null) {
                    throw new NullPointerException();
                }
                if (locale.equals(new Locale("", "CI"))) {
                    return Arrays.asList(locale, Locale.ROOT);
                }
                if (locale.equals(Locale.GERMANY)) {
                    return Arrays.asList(locale, Locale.ROOT);
                }
                return super.getCandidateLocales(baseName, locale);
            }
        }));
        private static final Parsing DEFAULT_CS = new Parsing(CASE_SENSITIVE_SYMBOLS, true);
        private static final Parsing DEFAULT_CI = new Parsing(CASE_INSENSITIVE_SYMBOLS, false);
        private final boolean caseSensitive;

        public Parsing(SymbolMap symbols, boolean caseSensitive) {
            super(symbols);
            this.caseSensitive = caseSensitive;
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq, ParsePosition cursor) throws ParserException {
            int start = cursor.getIndex();
            int end = csq.length();
            if (end <= start) {
                return Units.ONE;
            }
            String source = csq.subSequence(start, end).toString().trim();
            if (source.length() == 0) {
                return Units.ONE;
            }
            if (!this.caseSensitive) {
                source = source.toUpperCase();
            }
            UCUMFormatParser parser = new UCUMFormatParser(this.symbolMap, new ByteArrayInputStream(source.getBytes()));
            try {
                Unit result = parser.parseUnit();
                cursor.setIndex(end);
                return result;
            }
            catch (TokenException e) {
                if (e.currentToken != null) {
                    cursor.setErrorIndex(start + e.currentToken.endColumn);
                } else {
                    cursor.setErrorIndex(start);
                }
                throw new ParserException((Throwable)e);
            }
            catch (TokenMgrError e) {
                cursor.setErrorIndex(start);
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq) throws ParserException {
            return this.parse(csq, new ParsePosition(0));
        }
    }

    private static final class Print
    extends UCUMFormat {
        private static final SymbolMap PRINT_SYMBOLS = SymbolMap.of((ResourceBundle)ResourceBundle.getBundle(UCUMFormat.access$300() + "_Print"));
        private static final Print DEFAULT = new Print(PRINT_SYMBOLS);

        public Print(SymbolMap symbols) {
            super(symbols);
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq, ParsePosition pos) throws IllegalArgumentException {
            throw new UnsupportedOperationException("The print format is for pretty-printing of units only. Parsing is not supported.");
        }

        @Override
        void appendAnnotation(CharSequence symbol, CharSequence annotation, Appendable appendable) throws IOException {
            if (symbol != null && symbol.length() > 0) {
                appendable.append('(');
                appendable.append(annotation);
                appendable.append(')');
            } else {
                appendable.append(annotation);
            }
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq) throws IllegalArgumentException {
            return this.parse(csq, new ParsePosition(0));
        }
    }

    public static enum Variant {
        CASE_SENSITIVE,
        CASE_INSENSITIVE,
        PRINT;

    }
}

