/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SystemOfUnitsServiceTest {
    private static final String DEFAULT_SERVICE_CLASSNAME = "systems.uom.common.spi.CommonSystemService";
    private static final String COMMON_SERVICE_CLASSNAME = "systems.uom.common.spi.CommonSystemService";
    private static final Logger LOGGER = Logger.getLogger(SystemOfUnitsServiceTest.class.getName());
    private static final Level LOGLEVEL = Level.INFO;
    private static final int NUM_OF_UNITS_US = 47;
    private static final int NUM_OF_UNITS_IMPER = 24;
    private static final int NUM_OF_UNITS_CGS = 12;
    private static final int NUM_OF_UNITS_MKPS = 12;
    private static final int NUM_OF_UNITS_DEFAULT = 47;
    private static SystemOfUnitsService defaultService;

    @BeforeAll
    public static void setUp() {
        defaultService = ServiceProvider.current().getSystemOfUnitsService();
    }

    @Test
    public void testDefaultUnitSystemService() {
        Assertions.assertNotNull((Object)defaultService);
        Assertions.assertEquals((Object)"systems.uom.common.spi.CommonSystemService", (Object)defaultService.getClass().getName());
        SystemOfUnits system = defaultService.getSystemOfUnits();
        Assertions.assertNotNull((Object)system);
        Assertions.assertEquals((Object)"systems.uom.common.USCustomary", (Object)system.getClass().getName());
        Assertions.assertEquals((Object)"United States Customary Units", (Object)system.getName());
        Assertions.assertNotNull((Object)system.getUnits());
        Assertions.assertEquals((int)47, (int)system.getUnits().size());
    }

    @Test
    public void testCommonUnitSystemService() {
        ServiceProvider commonProvider = ServiceProvider.of((String)"Common");
        Assertions.assertNotNull((Object)commonProvider);
        SystemOfUnitsService commonService = commonProvider.getSystemOfUnitsService();
        Assertions.assertNotNull((Object)commonService);
        Assertions.assertEquals((Object)"systems.uom.common.spi.CommonSystemService", (Object)commonService.getClass().getName());
        SystemOfUnits system = commonService.getSystemOfUnits();
        Assertions.assertNotNull((Object)system);
        Assertions.assertEquals((Object)"systems.uom.common.USCustomary", (Object)system.getClass().getName());
        Assertions.assertEquals((Object)"United States Customary Units", (Object)system.getName());
        Assertions.assertNotNull((Object)system.getUnits());
        Assertions.assertEquals((int)47, (int)system.getUnits().size());
    }

    @Test
    public void testCommonUnitSystemServiceAlias() {
        ServiceProvider commonProvider = ServiceProvider.of((String)"Common");
        Assertions.assertNotNull((Object)commonProvider);
        SystemOfUnitsService commonService = commonProvider.getSystemOfUnitsService();
        Assertions.assertNotNull((Object)commonService);
        Assertions.assertEquals((Object)"systems.uom.common.spi.CommonSystemService", (Object)commonService.getClass().getName());
        SystemOfUnits system = commonService.getSystemOfUnits("USCustomary");
        Assertions.assertNotNull((Object)system);
        Assertions.assertEquals((Object)"systems.uom.common.USCustomary", (Object)system.getClass().getName());
        Assertions.assertEquals((Object)"United States Customary Units", (Object)system.getName());
        Assertions.assertNotNull((Object)system.getUnits());
        Assertions.assertEquals((int)47, (int)system.getUnits().size());
        SystemOfUnits system2 = commonService.getSystemOfUnits("US");
        Assertions.assertEquals((Object)system, (Object)system2);
        system = commonService.getSystemOfUnits("Imperial");
        Assertions.assertNotNull((Object)system);
        Assertions.assertEquals((Object)"systems.uom.common.Imperial", (Object)system.getClass().getName());
        Assertions.assertEquals((Object)"Imperial Units", (Object)system.getName());
        Assertions.assertNotNull((Object)system.getUnits());
        Assertions.assertEquals((int)24, (int)system.getUnits().size());
        system2 = commonService.getSystemOfUnits("UK");
        Assertions.assertEquals((Object)system, (Object)system2);
        system = commonService.getSystemOfUnits("CGS");
        Assertions.assertNotNull((Object)system);
        Assertions.assertEquals((Object)"Centimetre\u2013gram\u2013second System of Units", (Object)system.getName());
        system2 = commonService.getSystemOfUnits("Centimetre\u2013gram\u2013second");
        Assertions.assertEquals((Object)system, (Object)system2);
        Assertions.assertEquals((int)12, (int)system.getUnits().size());
        system = commonService.getSystemOfUnits("MKpS");
        Assertions.assertNotNull((Object)system);
        Assertions.assertEquals((Object)"Gravitational metric system", (Object)system.getName());
        Assertions.assertEquals((int)12, (int)system.getUnits().size());
        system2 = commonService.getSystemOfUnits("Gravitational metric system");
        Assertions.assertEquals((Object)system, (Object)system2);
        SystemOfUnits system3 = commonService.getSystemOfUnits("MKfS");
        Assertions.assertEquals((Object)system, (Object)system3);
        Assertions.assertEquals((Object)system2, (Object)system3);
    }

    @Test
    public void testOtherUnitSystemServices() {
        List services = ServiceProvider.available();
        Assertions.assertNotNull((Object)services);
        Assertions.assertEquals((int)3, (int)services.size());
        for (ServiceProvider provider : services) {
            LOGGER.log(LOGLEVEL, String.valueOf(provider));
        }
    }
}

