/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.measure.spi.ServiceProvider;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import systems.uom.common.USCustomary;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.unit.Units;

public class ArithmeticTest {
    private static Quantity<Length> sut;

    @BeforeAll
    public static void init() {
        sut = ServiceProvider.current().getQuantityFactory(Length.class).create((Number)10, Units.METRE);
    }

    @Test
    public void testValue() {
        Assert.assertEquals((Object)10, (Object)sut.getValue());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"10 m", (Object)sut.toString());
    }

    @Test
    public void testAdd() {
        ComparableQuantity km = Quantities.getQuantity((Number)1000, (Unit)Units.METRE);
        ComparableQuantity mile = Quantities.getQuantity((Number)1, (Unit)USCustomary.MILE);
        Quantity result = km.add((Quantity)mile);
        Assert.assertEquals((double)2609.344, (double)result.getValue().doubleValue(), (double)0.0);
        Assert.assertEquals((Object)Units.METRE, (Object)result.getUnit());
    }

    @Test
    public void testAdd2() {
        ComparableQuantity kg = Quantities.getQuantity((Number)50.0, (Unit)Units.KILOGRAM);
        ComparableQuantity p = Quantities.getQuantity((Number)10.0, (Unit)USCustomary.POUND);
        Quantity result = kg.add((Quantity)p);
        Assert.assertEquals((double)54.5359237, (double)result.getValue().doubleValue(), (double)0.0);
        Assert.assertEquals((Object)Units.KILOGRAM, (Object)result.getUnit());
    }

    @Test
    public void testSubtract() {
        ComparableQuantity km = Quantities.getQuantity((Number)2000, (Unit)Units.METRE);
        ComparableQuantity mile = Quantities.getQuantity((Number)1, (Unit)USCustomary.MILE);
        Quantity result = km.subtract((Quantity)mile);
        Assert.assertEquals((double)390.656, (double)result.getValue().doubleValue(), (double)0.0);
        Assert.assertEquals((Object)Units.METRE, (Object)result.getUnit());
    }

    @Test
    public void testSubtract2() {
        ComparableQuantity kg = Quantities.getQuantity((Number)50.0, (Unit)Units.KILOGRAM);
        ComparableQuantity p = Quantities.getQuantity((Number)10.0, (Unit)USCustomary.POUND);
        Quantity result = kg.subtract((Quantity)p);
        Assert.assertEquals((double)45.4640763, (double)result.getValue().doubleValue(), (double)0.0);
        Assert.assertEquals((Object)Units.KILOGRAM, (Object)result.getUnit());
    }
}

