/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import java.util.List;
import java.util.logging.Logger;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SystemOfUnitsServiceTest {
    private static final String DEFAULT_SERVICE_CLASSNAME = "tech.units.indriya.unit.DefaultSystemOfUnitsService";
    private static final String COMMON_SERVICE_CLASSNAME = "systems.uom.common.spi.CommonSystemService";
    private static final Logger LOGGER = Logger.getLogger(SystemOfUnitsServiceTest.class.getName());
    private static final int NUM_OF_UNITS_DEFAULT = 43;
    private static final int NUM_OF_UNITS_US = 45;
    private static final int NUM_OF_UNITS_CGS = 12;
    private static SystemOfUnitsService defaultService;

    @BeforeClass
    public static void setUp() {
        defaultService = ServiceProvider.current().getSystemOfUnitsService();
    }

    @Test
    public void testDefaultUnitSystemService() {
        Assert.assertNotNull((Object)defaultService);
        Assert.assertEquals((Object)DEFAULT_SERVICE_CLASSNAME, (Object)defaultService.getClass().getName());
        SystemOfUnits system = defaultService.getSystemOfUnits();
        Assert.assertNotNull((Object)system);
        Assert.assertEquals((Object)"tech.units.indriya.unit.Units", (Object)system.getClass().getName());
        Assert.assertEquals((Object)"Units", (Object)system.getName());
        Assert.assertNotNull((Object)system.getUnits());
        Assert.assertEquals((long)43L, (long)system.getUnits().size());
    }

    @Test
    public void testCommonUnitSystemService() {
        ServiceProvider commonProvider = ServiceProvider.of((String)"Common");
        Assert.assertNotNull((Object)commonProvider);
        SystemOfUnitsService commonService = commonProvider.getSystemOfUnitsService();
        Assert.assertNotNull((Object)commonService);
        Assert.assertEquals((Object)COMMON_SERVICE_CLASSNAME, (Object)commonService.getClass().getName());
        SystemOfUnits system = commonService.getSystemOfUnits();
        Assert.assertNotNull((Object)system);
        Assert.assertEquals((Object)"systems.uom.common.USCustomary", (Object)system.getClass().getName());
        Assert.assertEquals((Object)"United States Customary Units", (Object)system.getName());
        Assert.assertNotNull((Object)system.getUnits());
        Assert.assertEquals((long)45L, (long)system.getUnits().size());
    }

    @Test
    public void testCommonUnitSystemServiceAlias() {
        ServiceProvider commonProvider = ServiceProvider.of((String)"Common");
        Assert.assertNotNull((Object)commonProvider);
        SystemOfUnitsService commonService = commonProvider.getSystemOfUnitsService();
        Assert.assertNotNull((Object)commonService);
        Assert.assertEquals((Object)COMMON_SERVICE_CLASSNAME, (Object)commonService.getClass().getName());
        SystemOfUnits system = commonService.getSystemOfUnits("USCustomary");
        Assert.assertNotNull((Object)system);
        Assert.assertEquals((Object)"systems.uom.common.USCustomary", (Object)system.getClass().getName());
        Assert.assertEquals((Object)"United States Customary Units", (Object)system.getName());
        Assert.assertNotNull((Object)system.getUnits());
        Assert.assertEquals((long)45L, (long)system.getUnits().size());
        SystemOfUnits system2 = commonService.getSystemOfUnits("US");
        Assert.assertEquals((Object)system, (Object)system2);
        system = commonService.getSystemOfUnits("CGS");
        Assert.assertNotNull((Object)system);
        Assert.assertEquals((Object)"Centimetre\u2013gram\u2013second System of Units", (Object)system.getName());
        system2 = commonService.getSystemOfUnits("Centimetre\u2013gram\u2013second");
        Assert.assertEquals((Object)system, (Object)system2);
        Assert.assertEquals((long)12L, (long)system.getUnits().size());
    }

    @Test
    public void testOtherUnitSystemServices() {
        List services = ServiceProvider.available();
        Assert.assertNotNull((Object)services);
        Assert.assertEquals((long)3L, (long)services.size());
        for (ServiceProvider provider : services) {
            LOGGER.info(String.valueOf(provider));
        }
    }
}

