/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import java.util.Set;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import systems.uom.common.USCustomary;
import systems.uom.quantity.Information;
import systems.uom.quantity.Resolution;
import tec.units.ri.AbstractConverter;
import tec.units.ri.AbstractSystemOfUnits;
import tec.units.ri.AbstractUnit;
import tec.units.ri.format.SimpleUnitFormat;
import tec.units.ri.function.LogConverter;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.unit.AlternateUnit;
import tec.units.ri.unit.Units;

final class NonSI
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "Non-SI Units";
    private static final double AVOGADRO_CONSTANT = 6.02214199E23;
    private static final double ELEMENTARY_CHARGE = 1.602176462E-19;
    private static final NonSI INSTANCE = new NonSI();
    static final Unit<Dimensionless> PI = NonSI.addUnit(AbstractUnit.ONE.multiply(Math.PI));
    static final Unit<Dimensionless> DECIBEL = AbstractUnit.ONE.transform((UnitConverter)new LogConverter(10.0).inverse().concatenate((AbstractConverter)new RationalConverter(1.0, 10.0)));
    static final Unit<AmountOfSubstance> ATOM = Units.MOLE.divide(6.02214199E23);
    public static final Unit<Length> ANGSTROM = NonSI.addUnit(Units.METRE.divide(1.0E10), "\u00c5ngstr\u00f6m", "\u00c5");
    static final Unit<Length> ASTRONOMICAL_UNIT = NonSI.addUnit(Units.METRE.multiply(1.49597870691E11));
    static final Unit<Length> LIGHT_YEAR = NonSI.addUnit(Units.METRE.multiply(9.460528405E15));
    static final Unit<Length> PARSEC = Units.METRE.multiply(3.085677E16);
    static final Unit<Length> POINT = USCustomary.INCH.multiply(13837.0).divide(1000000.0);
    static final Unit<Time> DAY_SIDEREAL = NonSI.addUnit(Units.SECOND.multiply(86164.09));
    static final Unit<Time> YEAR_SIDEREAL = NonSI.addUnit(Units.SECOND.multiply(3.155814954E7));
    static final Unit<Time> YEAR_JULIEN = NonSI.addUnit(Units.SECOND.multiply(3.15576E7));
    static final Unit<Mass> ATOMIC_MASS = NonSI.addUnit(Units.KILOGRAM.multiply(1.6605387280149467E-27));
    static final Unit<Mass> ELECTRON_MASS = NonSI.addUnit(Units.KILOGRAM.multiply(9.10938188E-31));
    static final Unit<ElectricCharge> E = NonSI.addUnit(Units.COULOMB.multiply(1.602176462E-19));
    static final Unit<ElectricCharge> FARADAY = NonSI.addUnit(Units.COULOMB.multiply(96485.3414719984));
    static final Unit<ElectricCharge> FRANKLIN = NonSI.addUnit(Units.COULOMB.multiply(3.3356E-10));
    static final Unit<Temperature> RANKINE = Units.KELVIN.multiply(5.0).divide(9.0);
    static final Unit<Angle> REVOLUTION = NonSI.addUnit(Units.RADIAN.multiply(2.0).multiply(Math.PI).asType(Angle.class));
    static final Unit<Speed> C = Units.METRE_PER_SECOND.multiply(2.99792458E8);
    static final Unit<Information> BIT = new AlternateUnit(AbstractUnit.ONE, "bit");
    private static final Unit<Information> BYTE = BIT.multiply(8.0);
    static final Unit<Information> OCTET = BYTE;
    static final Unit<Length> PIXEL = NonSI.addUnit(BYTE.multiply(4.0).asType(Length.class));
    static final Unit<Resolution> PIXEL_PER_INCH = NonSI.addUnit(PIXEL.divide(USCustomary.INCH).asType(Resolution.class));
    static final Unit<Length> COMPUTER_POINT = PIXEL;
    static final Unit<ElectricCurrent> GILBERT = Units.AMPERE.multiply(10.0).divide(4.0).multiply(PI).asType(ElectricCurrent.class);
    static final Unit<Energy> ERG = Units.JOULE.divide(1.0E7);
    static final Unit<Energy> ELECTRON_VOLT = Units.JOULE.multiply(1.602176462E-19);
    static final Unit<Illuminance> LAMBERT = NonSI.addUnit(Units.LUX.multiply(10000.0));
    static final Unit<MagneticFlux> MAXWELL = NonSI.addUnit(Units.WEBER.divide(1.0E8));
    static final Unit<MagneticFluxDensity> GAUSS = NonSI.addUnit(Units.TESLA.divide(10000.0));
    static final Unit<Pressure> ATMOSPHERE = NonSI.addUnit(Units.PASCAL.multiply(101325.0));
    public static final Unit<Pressure> BAR = NonSI.addUnit(Units.PASCAL.multiply(100000.0), "Bar", "b");
    static final Unit<Pressure> MILLIMETRE_OF_MERCURY = NonSI.addUnit(Units.PASCAL.multiply(133.322));
    static final Unit<Pressure> INCH_OF_MERCURY = NonSI.addUnit(Units.PASCAL.multiply(3386.388));
    public static final Unit<RadiationDoseAbsorbed> RAD = NonSI.addUnit(Units.GRAY.divide(100.0), "Rad", "rd");
    static final Unit<RadiationDoseEffective> REM = NonSI.addUnit(Units.SIEVERT.divide(100.0));
    static final Unit<Radioactivity> CURIE = NonSI.addUnit(Units.BECQUEREL.multiply(3.7E10));
    static final Unit<Radioactivity> RUTHERFORD = NonSI.addUnit(Units.BECQUEREL.multiply(1000000.0));
    static final Unit<SolidAngle> SPHERE = NonSI.addUnit(Units.STERADIAN.multiply(4.0).multiply(PI).asType(SolidAngle.class));
    static final Unit<Frequency> FRAME_PER_SECOND = NonSI.addUnit(AbstractUnit.ONE.divide(Units.SECOND)).asType(Frequency.class);

    private NonSI() {
    }

    public static NonSI getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return SYSTEM_NAME;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        NonSI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel && text != null) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return (U)AbstractSystemOfUnits.Helper.addUnit((Set)NonSI.INSTANCE.units, unit, (String)name);
        }
        NonSI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text) {
        return NonSI.addUnit(unit, name, text, true);
    }
}

