/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import javax.measure.Unit;
import javax.measure.quantity.Area;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import systems.uom.common.USCustomary;
import tec.units.ri.AbstractSystemOfUnits;
import tec.units.ri.format.SimpleUnitFormat;
import tec.units.ri.unit.MetricPrefix;
import tec.units.ri.unit.ProductUnit;
import tec.units.ri.unit.Units;

public final class Imperial
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "Imperial";
    private static final Imperial INSTANCE = new Imperial();
    public static final Unit<Length> INCH = INSTANCE.addUnit(USCustomary.INCH, "Inch", "in");
    static final Unit<Mass> POUND = INSTANCE.addUnit(Units.KILOGRAM.multiply(4.5359237E7).divide(1.0E8), "Pound", "lb");
    public static final Unit<Mass> STONE = INSTANCE.addUnit(Units.KILOGRAM.multiply(6.35029318), "Stone", "st");
    public static final Unit<Mass> OUNCE = Imperial.addUnit(POUND.divide(16.0));
    public static final Unit<Mass> TON_UK = Imperial.addUnit(POUND.multiply(2240.0));
    public static final Unit<Mass> METRIC_TON = Imperial.addUnit(Units.KILOGRAM.multiply(1000.0));
    static final Unit<Temperature> RANKINE = Imperial.addUnit(Units.KELVIN.multiply(5.0).divide(9.0));
    static final Unit<Temperature> FAHRENHEIT = Imperial.addUnit(RANKINE.shift(459.67));
    static final Unit<Time> MINUTE = Imperial.addUnit(Units.SECOND.multiply(60.0));
    static final Unit<Time> HOUR = Imperial.addUnit(MINUTE.multiply(60.0));
    public static final Unit<Area> SQUARE_FOOT = USCustomary.SQUARE_FOOT;
    public static final Unit<Area> ACRE = Imperial.addUnit(USCustomary.SQUARE_FOOT.multiply(43560.0));
    static final Unit<Volume> LITRE = Imperial.addUnit(Units.CUBIC_METRE.divide(1000.0));
    static final Unit<Volume> CUBIC_INCH = Imperial.addUnit(new ProductUnit(USCustomary.INCH.pow(3)));
    public static final Unit<Volume> GALLON_UK = Imperial.addUnit(LITRE.multiply(454609.0).divide(100000.0));
    public static final Unit<Volume> GALLON_LIQUID = Imperial.addUnit(CUBIC_INCH.multiply(277.42));
    static final Unit<Volume> OUNCE_LIQUID_UK = Imperial.addUnit(GALLON_UK.divide(160.0));
    public static final Unit<Volume> OUNCE_LIQUID = OUNCE_LIQUID_UK;
    public static final Unit<Volume> GILL = Imperial.addUnit(OUNCE_LIQUID.multiply(5.0));
    public static final Unit<Volume> PINT = Imperial.addUnit(OUNCE_LIQUID.multiply(20.0));
    public static final Unit<Volume> QUART = Imperial.addUnit(OUNCE_LIQUID.multiply(40.0));
    public static final Unit<Volume> MINIM = Imperial.addUnit(MetricPrefix.MICRO(LITRE).multiply(59.1938802));
    public static final Unit<Volume> FLUID_SCRUPLE = Imperial.addUnit(MINIM.multiply(60.0));
    public static final Unit<Volume> FLUID_DRACHM = Imperial.addUnit(FLUID_SCRUPLE.multiply(3.0));

    private Imperial() {
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        Imperial.INSTANCE.units.add(unit);
        return unit;
    }

    public String getName() {
        return SYSTEM_NAME;
    }

    static {
        SimpleUnitFormat.getInstance().label(POUND, "lb");
        SimpleUnitFormat.getInstance().label(LITRE, "L");
        SimpleUnitFormat.getInstance().label(FLUID_DRACHM, "fl drc");
        SimpleUnitFormat.getInstance().label(FLUID_SCRUPLE, "fl scr");
        SimpleUnitFormat.getInstance().label(PINT, "pt");
    }
}

