/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import systems.uom.common.US;
import tec.units.ri.quantity.DefaultQuantityFactory;
import tec.units.ri.quantity.Quantities;
import tec.units.ri.unit.Units;

public class ArithmeticTest {
    private Quantity<Length> sut;

    @Before
    public void init() {
        this.sut = DefaultQuantityFactory.getInstance(Length.class).create((Number)10, Units.METRE);
    }

    @Test
    public void testValue() {
        Assert.assertEquals((Object)10, (Object)this.sut.getValue());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"10 m", (Object)this.sut.toString());
    }

    @Test
    public void testAdd() {
        Quantity km = Quantities.getQuantity((Number)1000, (Unit)Units.METRE);
        Quantity mile = Quantities.getQuantity((Number)1, (Unit)US.MILE);
        Quantity result = km.add(mile);
        Assert.assertEquals((Object)2609, (Object)result.getValue());
        Assert.assertEquals((Object)Units.METRE, (Object)result.getUnit());
    }

    @Test
    public void testAdd2() {
        Quantity kg = Quantities.getQuantity((Number)50.0, (Unit)Units.KILOGRAM);
        Quantity p = Quantities.getQuantity((Number)10.0, (Unit)US.POUND);
        Quantity result = kg.add(p);
        Assert.assertEquals((Object)54.5359237, (Object)result.getValue());
        Assert.assertEquals((Object)Units.KILOGRAM, (Object)result.getUnit());
    }

    @Test
    public void testSubtract() {
        Quantity km = Quantities.getQuantity((Number)2000, (Unit)Units.METRE);
        Quantity mile = Quantities.getQuantity((Number)1, (Unit)US.MILE);
        Quantity result = km.subtract(mile);
        Assert.assertEquals((Object)391, (Object)result.getValue());
        Assert.assertEquals((Object)Units.METRE, (Object)result.getUnit());
    }

    @Test
    public void testSubtract2() {
        Quantity kg = Quantities.getQuantity((Number)50.0, (Unit)Units.KILOGRAM);
        Quantity p = Quantities.getQuantity((Number)10.0, (Unit)US.POUND);
        Quantity result = kg.subtract(p);
        Assert.assertEquals((Object)45.4640763, (Object)result.getValue());
        Assert.assertEquals((Object)Units.KILOGRAM, (Object)result.getUnit());
    }
}

