/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import java.math.BigDecimal;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import systems.uom.common.USCustomary;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.Units;

public class ArithmeticTest {
    private Quantity<Length> sut;

    @Before
    public void init() {
        this.sut = Quantities.getQuantity((Number)10, (Unit)Units.METRE);
    }

    @Test
    public void testValue() {
        Assert.assertEquals((Object)10, (Object)this.sut.getValue());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"10 m", (Object)this.sut.toString());
    }

    @Test
    public void testAdd() {
        ComparableQuantity km = Quantities.getQuantity((Number)1000, (Unit)Units.METRE);
        ComparableQuantity mile = Quantities.getQuantity((Number)1, (Unit)USCustomary.MILE);
        Quantity result = km.add((Quantity)mile);
        Assert.assertEquals((Object)BigDecimal.valueOf(2609.344), (Object)result.getValue());
        Assert.assertEquals((Object)Units.METRE, (Object)result.getUnit());
    }

    @Test
    public void testAdd2() {
        ComparableQuantity kg = Quantities.getQuantity((Number)50.0, (Unit)Units.KILOGRAM);
        ComparableQuantity p = Quantities.getQuantity((Number)10.0, (Unit)USCustomary.POUND);
        Quantity result = kg.add((Quantity)p);
        Assert.assertEquals((Object)54.5359237, (Object)result.getValue());
        Assert.assertEquals((Object)Units.KILOGRAM, (Object)result.getUnit());
    }

    @Test
    public void testSubtract() {
        ComparableQuantity km = Quantities.getQuantity((Number)2000, (Unit)Units.METRE);
        ComparableQuantity mile = Quantities.getQuantity((Number)1, (Unit)USCustomary.MILE);
        Quantity result = km.subtract((Quantity)mile);
        Assert.assertEquals((Object)BigDecimal.valueOf(390.656), (Object)result.getValue());
        Assert.assertEquals((Object)Units.METRE, (Object)result.getUnit());
    }

    @Test
    public void testSubtract2() {
        ComparableQuantity kg = Quantities.getQuantity((Number)50.0, (Unit)Units.KILOGRAM);
        ComparableQuantity p = Quantities.getQuantity((Number)10.0, (Unit)USCustomary.POUND);
        Quantity result = kg.subtract((Quantity)p);
        Assert.assertEquals((Object)45.4640763, (Object)result.getValue());
        Assert.assertEquals((Object)Units.KILOGRAM, (Object)result.getUnit());
    }
}

