/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import java.util.List;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SystemOfUnitsServiceTest {
    private static final String EXPECTED_SYSTEM_NAME = "United State Customary Units";
    private static SystemOfUnitsService defaultService;

    @BeforeClass
    public static void setUp() {
        defaultService = ServiceProvider.current().getSystemOfUnitsService();
    }

    @Test
    public void testDefaultUnitSystemService() {
        Assert.assertNotNull((Object)defaultService);
        Assert.assertEquals((Object)"systems.uom.common.internal.CommonSystemService", (Object)defaultService.getClass().getName());
        SystemOfUnits system = defaultService.getSystemOfUnits();
        Assert.assertNotNull((Object)system);
        Assert.assertEquals((Object)"systems.uom.common.USCustomary", (Object)system.getClass().getName());
        Assert.assertEquals((Object)EXPECTED_SYSTEM_NAME, (Object)system.getName());
        Assert.assertNotNull((Object)system.getUnits());
        Assert.assertEquals((long)43L, (long)system.getUnits().size());
    }

    @Test
    public void testUnitSystemServiceAlias() {
        Assert.assertNotNull((Object)defaultService);
        Assert.assertEquals((Object)"systems.uom.common.internal.CommonSystemService", (Object)defaultService.getClass().getName());
        SystemOfUnits system = defaultService.getSystemOfUnits("USCustomary");
        Assert.assertNotNull((Object)system);
        Assert.assertEquals((Object)"systems.uom.common.USCustomary", (Object)system.getClass().getName());
        Assert.assertEquals((Object)EXPECTED_SYSTEM_NAME, (Object)system.getName());
        Assert.assertNotNull((Object)system.getUnits());
        Assert.assertEquals((long)43L, (long)system.getUnits().size());
        SystemOfUnits system2 = defaultService.getSystemOfUnits("US");
        Assert.assertEquals((Object)system, (Object)system2);
        system = defaultService.getSystemOfUnits("NonSI");
        Assert.assertNotNull((Object)system);
        Assert.assertEquals((Object)"Non-SI Units", (Object)system.getName());
        system2 = defaultService.getSystemOfUnits("Non-SI");
        Assert.assertEquals((Object)system, (Object)system2);
    }

    @Test
    public void testOtherUnitSystemServices() {
        List services = ServiceProvider.available();
        Assert.assertNotNull((Object)services);
        Assert.assertEquals((long)3L, (long)services.size());
    }
}

