/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import si.uom.quantity.DynamicViscosity;
import si.uom.quantity.IonizingRadiation;
import si.uom.quantity.KinematicViscosity;
import systems.uom.quantity.Information;
import systems.uom.quantity.InformationRate;
import systems.uom.quantity.Resolution;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractSystemOfUnits;
import tec.uom.se.AbstractUnit;
import tec.uom.se.function.LogConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.Units;

final class NonSI
extends AbstractSystemOfUnits {
    private static final int STANDARD_GRAVITY_DIVIDEND = 980665;
    private static final int STANDARD_GRAVITY_DIVISOR = 100000;
    public static final int AVOIRDUPOIS_POUND_DIVIDEND = 45359237;
    public static final int AVOIRDUPOIS_POUND_DIVISOR = 100000000;
    private static final double AVOGADRO_CONSTANT = 6.02214199E23;
    private static final double ELEMENTARY_CHARGE = 1.602176462E-19;
    private static final NonSI INSTANCE = new NonSI();
    static final Unit<Dimensionless> PI = NonSI.addUnit(Units.ONE.multiply(Math.PI));
    static final Unit<Dimensionless> DECIBEL = NonSI.addUnit(Units.ONE.transform((UnitConverter)new LogConverter(10.0).inverse().concatenate((AbstractConverter)RationalConverter.of((double)1.0, (double)10.0))));
    static final Unit<AmountOfSubstance> ATOM = NonSI.addUnit(Units.MOLE.divide(6.02214199E23));
    static final Unit<Length> FOOT = NonSI.addUnit(Units.METRE.multiply(3048.0).divide(10000.0));
    static final Unit<Length> INCH = NonSI.addUnit(FOOT.divide(12.0));
    static final Unit<Length> ANGSTROM = NonSI.addUnit(Units.METRE.divide(1.0E10));
    static final Unit<Length> ASTRONOMICAL_UNIT = NonSI.addUnit(Units.METRE.multiply(1.49597870691E11));
    static final Unit<Length> LIGHT_YEAR = NonSI.addUnit(Units.METRE.multiply(9.460528405E15));
    static final Unit<Length> PARSEC = NonSI.addUnit(Units.METRE.multiply(3.085677E16));
    static final Unit<Length> POINT = NonSI.addUnit(INCH.multiply(13837.0).divide(1000000.0));
    public static final Unit<Time> MINUTE = NonSI.addUnit(Units.SECOND.multiply(60.0));
    public static final Unit<Time> HOUR = NonSI.addUnit(MINUTE.multiply(60.0));
    public static final Unit<Time> DAY = NonSI.addUnit(HOUR.multiply(24.0));
    static final Unit<Time> DAY_SIDEREAL = NonSI.addUnit(Units.SECOND.multiply(86164.09));
    static final Unit<Time> WEEK = NonSI.addUnit(DAY.multiply(7.0));
    static final Unit<Time> YEAR_CALENDAR = NonSI.addUnit(DAY.multiply(365.0));
    static final Unit<Time> YEAR_SIDEREAL = NonSI.addUnit(Units.SECOND.multiply(3.155814954E7));
    static final Unit<Time> YEAR_JULIEN = NonSI.addUnit(Units.SECOND.multiply(3.15576E7));
    static final Unit<Mass> ATOMIC_MASS = NonSI.addUnit(Units.KILOGRAM.multiply(1.6605387280149467E-27));
    static final Unit<Mass> ELECTRON_MASS = NonSI.addUnit(Units.KILOGRAM.multiply(9.10938188E-31));
    static final Unit<Mass> POUND = NonSI.addUnit(Units.KILOGRAM.multiply(4.5359237E7).divide(1.0E8));
    static final Unit<ElectricCharge> E = NonSI.addUnit(Units.COULOMB.multiply(1.602176462E-19));
    static final Unit<ElectricCharge> FARADAY = NonSI.addUnit(Units.COULOMB.multiply(96485.3414719984));
    static final Unit<ElectricCharge> FRANKLIN = NonSI.addUnit(Units.COULOMB.multiply(3.3356E-10));
    static final Unit<Temperature> RANKINE = NonSI.addUnit(Units.KELVIN.multiply(5.0).divide(9.0));
    static final Unit<Angle> REVOLUTION = NonSI.addUnit(Units.RADIAN.multiply(2.0).multiply(Math.PI).asType(Angle.class));
    static final Unit<Speed> C = NonSI.addUnit(Units.METRES_PER_SECOND.multiply(2.99792458E8));
    static final Unit<Acceleration> G = NonSI.addUnit(Units.METRES_PER_SQUARE_SECOND.multiply(980665.0).divide(100000.0));
    static final Unit<Area> ARE = NonSI.addUnit(Units.SQUARE_METRE.multiply(100.0));
    public static final Unit<Information> BIT = NonSI.addUnit(new AlternateUnit(Units.ONE, "bit"), Information.class);
    public static final Unit<Information> BYTE = NonSI.addUnit(BIT.multiply(8.0));
    public static final ProductUnit<InformationRate> BITS_PER_SECOND = NonSI.addUnit(new ProductUnit(BIT.divide(Units.SECOND)), InformationRate.class);
    static final Unit<Information> OCTET = BYTE;
    static final Unit<Information> PIXEL = NonSI.addUnit(BYTE.multiply(4.0));
    static final Unit<Resolution> PIXEL_PER_INCH = NonSI.addUnit(PIXEL.divide(INCH).asType(Resolution.class));
    static final Unit<Information> COMPUTER_POINT = PIXEL;
    static final Unit<ElectricCurrent> GILBERT = NonSI.addUnit(Units.AMPERE.multiply(10.0).divide(4.0).multiply(PI).asType(ElectricCurrent.class));
    static final Unit<Energy> ERG = NonSI.addUnit(Units.JOULE.divide(1.0E7));
    static final Unit<Energy> ELECTRON_VOLT = NonSI.addUnit(Units.JOULE.multiply(1.602176462E-19));
    static final Unit<Illuminance> LAMBERT = NonSI.addUnit(Units.LUX.multiply(10000.0));
    static final Unit<MagneticFlux> MAXWELL = NonSI.addUnit(Units.WEBER.divide(1.0E8));
    static final Unit<MagneticFluxDensity> GAUSS = NonSI.addUnit(Units.TESLA.divide(10000.0));
    static final Unit<Force> DYNE = NonSI.addUnit(Units.NEWTON.divide(100000.0));
    static final Unit<Force> KILOGRAM_FORCE = NonSI.addUnit(Units.NEWTON.multiply(980665.0).divide(100000.0));
    static final Unit<Force> POUND_FORCE = NonSI.addUnit(Units.NEWTON.multiply(4.4482216152605E13).divide(1.0E13));
    static final Unit<Power> HORSEPOWER = NonSI.addUnit(Units.WATT.multiply(735.499));
    static final Unit<Pressure> ATMOSPHERE = NonSI.addUnit(Units.PASCAL.multiply(101325.0));
    static final Unit<Pressure> BAR = NonSI.addUnit(Units.PASCAL.multiply(100000.0));
    static final Unit<Pressure> MILLIMETRE_OF_MERCURY = NonSI.addUnit(Units.PASCAL.multiply(133.322));
    static final Unit<Pressure> INCH_OF_MERCURY = NonSI.addUnit(Units.PASCAL.multiply(3386.388));
    static final Unit<RadiationDoseAbsorbed> RAD = NonSI.addUnit(Units.GRAY.divide(100.0));
    static final Unit<RadiationDoseEffective> REM = NonSI.addUnit(Units.SIEVERT.divide(100.0));
    static final Unit<Radioactivity> CURIE = NonSI.addUnit(Units.BECQUEREL.multiply(3.7E10));
    static final Unit<Radioactivity> RUTHERFORD = NonSI.addUnit(Units.BECQUEREL.multiply(1000000.0));
    static final Unit<SolidAngle> SPHERE = NonSI.addUnit(Units.STERADIAN.multiply(4.0).multiply(PI).asType(SolidAngle.class));
    static final Unit<DynamicViscosity> POISE = NonSI.addUnit(Units.GRAM.divide(MetricPrefix.CENTI((Unit)Units.METRE).multiply(Units.SECOND))).asType(DynamicViscosity.class);
    static final Unit<KinematicViscosity> STOKE = NonSI.addUnit(MetricPrefix.CENTI((Unit)Units.METRE).pow(2).divide(Units.SECOND)).asType(KinematicViscosity.class);
    static final Unit<Frequency> FRAMES_PER_SECOND = NonSI.addUnit(Units.ONE.divide(Units.SECOND)).asType(Frequency.class);
    public static final Unit<IonizingRadiation> ROENTGEN = INSTANCE.addUnit(Units.COULOMB.divide((AbstractUnit)Units.KILOGRAM).multiply(2.58E-4), "Roentgen");

    private NonSI() {
    }

    static NonSI getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        NonSI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        NonSI.INSTANCE.units.add(unit);
        NonSI.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }
}

