/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import systems.uom.common.NonSI;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.Units;

public class PixelTest {
    @Test
    public void testPPItoMetreConversion() throws UnconvertibleException, IncommensurableException {
        ComparableQuantity screenWidth = Quantities.getQuantity((Number)960, (Unit)NonSI.PIXEL);
        ComparableQuantity screenResolution = Quantities.getQuantity((Number)96, (Unit)NonSI.PIXEL_PER_INCH);
        ComparableQuantity ppi = screenWidth.divide((Quantity)screenResolution).asType(Length.class);
        ComparableQuantity pixelToMetre = ppi.to(Units.METRE);
        Assert.assertThat((Object)pixelToMetre.getValue().doubleValue(), (Matcher)CoreMatchers.is((Object)0.254));
        Assert.assertThat((Object)pixelToMetre.to(MetricPrefix.CENTI((Unit)Units.METRE)).getValue().doubleValue(), (Matcher)CoreMatchers.is((Object)25.4));
    }
}

