/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import javax.measure.Unit;
import org.junit.Assert;
import org.junit.Test;
import si.uom.SI;
import si.uom.impl.quantity.AccelerationAmount;
import si.uom.impl.quantity.ForceAmount;
import si.uom.impl.quantity.MassAmount;
import systems.uom.common.NewtonsSecondLaw;
import tec.uom.se.internal.format.OutputHelper;

public class NewtonsSecondLawTest {
    @Test
    public void testCalculateForce() {
        OutputHelper.println((String)"Calculate Force");
        MassAmount m = new MassAmount((Number)1000, SI.GRAM);
        AccelerationAmount a = new AccelerationAmount((Number)2.5, SI.METRES_PER_SQUARE_SECOND);
        ForceAmount force = NewtonsSecondLaw.calculateForce(m, a);
        OutputHelper.println((String)("ForceAmount = " + force.doubleValue((Unit)SI.NEWTON)));
        Assert.assertEquals((double)2500000.0, (double)force.doubleValue((Unit)SI.NEWTON), (double)1.0E-4);
    }

    @Test
    public void testCalculateForceKg() {
        MassAmount m = new MassAmount((Number)1, (Unit)SI.KILOGRAM);
        AccelerationAmount a = new AccelerationAmount((Number)2.5, SI.METRES_PER_SQUARE_SECOND);
        ForceAmount force = NewtonsSecondLaw.calculateForce(m, a);
        Assert.assertEquals((double)2.5, (double)force.doubleValue((Unit)SI.NEWTON), (double)1.0E-4);
    }
}

