/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.registry.io;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.configuration.gson.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.io.IOUtils;
import systems.reformcloud.reformcloud2.executor.api.registry.io.FileRegistry;

public class DefaultFileRegistry
implements FileRegistry {
    private final String operatingFolder;

    public DefaultFileRegistry(String operatingFolder) {
        this.operatingFolder = operatingFolder;
        IOUtils.createDirectory((Path)Paths.get(operatingFolder, new String[0]));
    }

    @NotNull
    public <T> T createKey(@NotNull String keyName, @NotNull T t) {
        Path filePath = Paths.get(this.operatingFolder, keyName + ".json");
        if (Files.exists(filePath, new LinkOption[0])) {
            return t;
        }
        new JsonConfiguration().add("key", t).write(filePath);
        return t;
    }

    @NotNull
    public <T> Optional<T> getKey(@NotNull String keyName) {
        Path filePath = Paths.get(this.operatingFolder, keyName + ".json");
        if (Files.notExists(filePath, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.ofNullable(JsonConfiguration.read((Path)filePath).get("key", new TypeToken<T>(){}));
    }

    public void deleteKey(@NotNull String key) {
        IOUtils.deleteFile((File)new File(this.operatingFolder, key + ".json"));
    }

    public <T> void updateKey(@NotNull String key, @NotNull T newValue) {
        Path filePath = Paths.get(this.operatingFolder, key + ".json");
        if (Files.notExists(filePath, new LinkOption[0])) {
            return;
        }
        new JsonConfiguration().add("key", newValue).write(filePath);
    }

    @NotNull
    public <T> Collection<T> readKeys(@NotNull Function<JsonConfiguration, T> function, @NotNull Consumer<Path> failureHandler) {
        CopyOnWriteArrayList<T> result = new CopyOnWriteArrayList<T>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(this.operatingFolder, new String[0]), path -> path.toString().endsWith(".json"));){
            for (Path path2 : stream) {
                T t = function.apply(JsonConfiguration.read((Path)path2));
                if (t == null) {
                    failureHandler.accept(path2);
                    continue;
                }
                result.add(t);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return result;
    }
}

