/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.process;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.builder.ProcessBuilder;
import systems.reformcloud.reformcloud2.executor.api.configuration.gson.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.groups.ProcessGroup;
import systems.reformcloud.reformcloud2.executor.api.groups.template.Template;
import systems.reformcloud.reformcloud2.executor.api.process.ProcessState;
import systems.reformcloud.reformcloud2.executor.api.process.api.ProcessInclusion;

public abstract class AbstractProcessBuilder
implements ProcessBuilder {
    protected String processGroupName;
    protected String node;
    protected String displayName;
    protected String messageOfTheDay;
    protected String targetProcessFactory;
    protected ProcessGroup processGroup;
    protected Template template;
    protected Collection<ProcessInclusion> inclusions = new CopyOnWriteArrayList<ProcessInclusion>();
    protected JsonConfiguration extra = new JsonConfiguration();
    protected ProcessState initialState = ProcessState.READY;
    protected UUID processUniqueId = UUID.randomUUID();
    protected int memory = -1;
    protected int id = -1;
    protected int maxPlayers = -1;

    protected AbstractProcessBuilder() {
    }

    @NotNull
    public ProcessBuilder targetProcessFactory(@Nullable String targetProcessFactory) {
        this.targetProcessFactory = targetProcessFactory;
        return this;
    }

    @NotNull
    public ProcessBuilder group(@NotNull String processGroupName) {
        this.processGroupName = processGroupName;
        return this;
    }

    @NotNull
    public ProcessBuilder group(@NotNull ProcessGroup processGroup) {
        this.processGroup = processGroup;
        return this;
    }

    @NotNull
    public ProcessBuilder node(@NotNull String node) {
        this.node = node;
        return this;
    }

    @NotNull
    public ProcessBuilder memory(int memory) {
        this.memory = memory;
        return this;
    }

    @NotNull
    public ProcessBuilder id(int id) {
        this.id = id;
        return this;
    }

    @NotNull
    public ProcessBuilder displayName(@NotNull String displayName) {
        this.displayName = displayName;
        return this;
    }

    @NotNull
    public ProcessBuilder messageOfTheDay(@NotNull String messageOfTheDay) {
        this.messageOfTheDay = messageOfTheDay;
        return this;
    }

    @NotNull
    public ProcessBuilder maxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
        return this;
    }

    @NotNull
    public ProcessBuilder template(@NotNull Template template) {
        this.template = template;
        return this;
    }

    @NotNull
    public ProcessBuilder inclusions(ProcessInclusion ... inclusions) {
        this.inclusions = Arrays.asList(inclusions);
        return this;
    }

    @NotNull
    public ProcessBuilder inclusions(@NotNull Collection<ProcessInclusion> inclusions) {
        this.inclusions = inclusions;
        return this;
    }

    @NotNull
    public ProcessBuilder extra(@NotNull JsonConfiguration extra) {
        this.extra = extra;
        return this;
    }

    @NotNull
    public ProcessBuilder initialState(@NotNull ProcessState initialState) {
        this.initialState = initialState;
        return this;
    }

    @NotNull
    public ProcessBuilder uniqueId(@NotNull UUID uniqueId) {
        this.processUniqueId = uniqueId;
        return this;
    }
}

