/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.network.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.network.NetworkUtil;
import systems.reformcloud.reformcloud2.executor.api.network.channel.EndpointChannelReader;
import systems.reformcloud.reformcloud2.executor.api.network.server.NetworkServer;
import systems.reformcloud.reformcloud2.executor.api.network.transport.EventLoopGroupType;
import systems.reformcloud.reformcloud2.shared.network.server.ServerChannelInitializer;

public final class DefaultNetworkServer
implements NetworkServer {
    private final Map<Integer, ChannelFuture> channelFutures = new ConcurrentHashMap<Integer, ChannelFuture>();
    private final EventLoopGroup boss = NetworkUtil.TRANSPORT_TYPE.getEventLoopGroup(EventLoopGroupType.BOSS);
    private final EventLoopGroup worker = NetworkUtil.TRANSPORT_TYPE.getEventLoopGroup(EventLoopGroupType.WORKER);

    public void bind(@NotNull String host, int port, @NotNull Supplier<EndpointChannelReader> readerHelper) {
        if (!this.channelFutures.containsKey(port)) {
            ((ServerBootstrap)new ServerBootstrap().channelFactory(NetworkUtil.TRANSPORT_TYPE.getServerSocketChannelFactory())).group(this.boss, this.worker).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.IP_TOS, (Object)24).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)NetworkUtil.WATER_MARK).childHandler((ChannelHandler)new ServerChannelInitializer(readerHelper)).bind(host, port).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                if (channelFuture.isSuccess()) {
                    this.channelFutures.put(port, (ChannelFuture)channelFuture);
                } else {
                    channelFuture.cause().printStackTrace();
                }
            }));
        }
    }

    public void close(int port) {
        ChannelFuture channelFuture = this.channelFutures.remove(port);
        if (channelFuture != null) {
            channelFuture.cancel(true);
        }
    }

    public void closeAll() {
        for (ChannelFuture value : this.channelFutures.values()) {
            value.cancel(true);
        }
        this.channelFutures.clear();
        this.worker.shutdownGracefully();
        this.boss.shutdownGracefully();
    }
}

