/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.network.packet;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.network.channel.NetworkChannel;
import systems.reformcloud.reformcloud2.executor.api.network.packet.Packet;
import systems.reformcloud.reformcloud2.executor.api.network.packet.query.QueryManager;
import systems.reformcloud.reformcloud2.executor.api.task.Task;
import systems.reformcloud.reformcloud2.executor.api.task.defaults.DefaultTask;

public class DefaultQueryManager
implements QueryManager {
    private final Map<UUID, Task<Packet>> waitingQueries = new ConcurrentHashMap<UUID, Task<Packet>>();

    @NotNull
    public Optional<Task<Packet>> getWaitingQuery(@NotNull UUID queryUniqueId) {
        return Optional.ofNullable(this.waitingQueries.remove(queryUniqueId));
    }

    @NotNull
    public Task<Packet> sendPacketQuery(@NotNull NetworkChannel channel, @NotNull UUID queryUniqueId, @NotNull Packet packet) {
        packet.setQueryUniqueID(queryUniqueId);
        DefaultTask task = new DefaultTask();
        this.waitingQueries.put(queryUniqueId, (Task<Packet>)task);
        channel.sendPacket((Object)packet);
        return task;
    }
}

