/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.network.packet;

import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.network.packet.Packet;
import systems.reformcloud.reformcloud2.executor.api.network.packet.PacketProvider;
import systems.reformcloud.reformcloud2.executor.api.network.packet.exception.PacketAlreadyRegisteredException;

public class DefaultPacketProvider
implements PacketProvider {
    private final Map<Integer, Class<? extends Packet>> packetClasses = new ConcurrentHashMap<Integer, Class<? extends Packet>>();

    public void registerPacket(@NotNull Class<? extends Packet> packetClass) throws PacketAlreadyRegisteredException {
        this.registerPacket(this.newInstanceFromClass(packetClass));
    }

    public void registerPacket(@NotNull Packet packet) throws PacketAlreadyRegisteredException {
        Optional<Packet> packetOptional = this.getPacketById(packet.getId());
        if (packetOptional.isPresent()) {
            throw new PacketAlreadyRegisteredException(packet.getClass().getName(), packetOptional.get().getClass().getName(), packet.getId());
        }
        this.packetClasses.put(packet.getId(), packet.getClass());
    }

    public void registerPackets(@NotNull Collection<Class<? extends Packet>> packetClasses) throws PacketAlreadyRegisteredException {
        for (Class<? extends Packet> packetClass : packetClasses) {
            this.registerPacket(packetClass);
        }
    }

    public void registerPacket(@NotNull Collection<Packet> packets) throws PacketAlreadyRegisteredException {
        for (Packet packet : packets) {
            this.registerPacket(packet);
        }
    }

    public void unregisterPacket(int id) {
        this.packetClasses.remove(id);
    }

    @NotNull
    public Optional<Packet> getPacketById(int id) {
        Class<? extends Packet> packetClass = this.packetClasses.get(id);
        return packetClass != null ? Optional.of(this.newInstanceFromClass(packetClass)) : Optional.empty();
    }

    public void clearRegisteredPackets() {
        this.packetClasses.clear();
    }

    @NotNull
    private Packet newInstanceFromClass(@NotNull Class<? extends Packet> packetClass) {
        try {
            return packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException exception) {
            System.err.println("Unable to load packet " + packetClass.getName() + " -> NoArgsConstructor is missing");
            System.err.println("Please report this or fix your application before running the system again");
            throw new EmptyStackException();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

