/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.network.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.CommonHelper;
import systems.reformcloud.reformcloud2.executor.api.network.NetworkUtil;
import systems.reformcloud.reformcloud2.executor.api.network.channel.EndpointChannelReader;
import systems.reformcloud.reformcloud2.executor.api.network.client.NetworkClient;
import systems.reformcloud.reformcloud2.executor.api.network.transport.EventLoopGroupType;
import systems.reformcloud.reformcloud2.shared.network.client.ClientChannelInitializer;

public final class DefaultNetworkClient
implements NetworkClient {
    private final EventLoopGroup eventLoopGroup = NetworkUtil.TRANSPORT_TYPE.getEventLoopGroup(EventLoopGroupType.WORKER);
    private Channel channel;

    public boolean connect(@NotNull String host, int port, @NotNull Supplier<EndpointChannelReader> supplier) {
        try {
            ChannelFuture future = this.connect0(host, port, supplier).sync();
            if (future.isSuccess()) {
                this.channel = future.channel();
            }
            return future.isSuccess();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @NotNull
    private ChannelFuture connect0(@NotNull String host, int port, @NotNull Supplier<EndpointChannelReader> supplier) {
        return ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channelFactory(NetworkUtil.TRANSPORT_TYPE.getSocketChannelFactory())).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.IP_TOS, (Object)24)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)CommonHelper.longToInt((long)TimeUnit.SECONDS.toMillis(5L)))).handler((ChannelHandler)new ClientChannelInitializer(supplier))).connect(host, port).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, ChannelFutureListener.CLOSE_ON_FAILURE});
    }

    public void disconnect() {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        this.eventLoopGroup.shutdownGracefully();
    }
}

