/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.network.channel;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.network.channel.NetworkChannel;
import systems.reformcloud.reformcloud2.executor.api.network.packet.Packet;

public final class DefaultNetworkChannel
implements NetworkChannel {
    private final Channel channel;
    private final long connectionTime = System.currentTimeMillis();
    private InetSocketAddress address;
    private boolean authenticated;
    private String name;

    DefaultNetworkChannel(Channel channel) {
        this.channel = channel;
        this.address = (InetSocketAddress)channel.remoteAddress();
    }

    public void sendPacket(@NotNull Object packet) {
        this.channel.writeAndFlush(packet, this.channel.voidPromise());
    }

    public void sendPackets(Object ... packets) {
        for (Object packet : packets) {
            this.sendPacket(packet);
        }
    }

    public void sendQueryResult(@Nullable UUID queryUniqueID, @NotNull Packet result) {
        result.setQueryUniqueID(queryUniqueID);
        this.sendPacket(result);
    }

    public long getConnectionTime() {
        return this.connectionTime;
    }

    @NotNull
    public String getAddress() {
        return this.address.getAddress().getHostAddress();
    }

    @NotNull
    public InetSocketAddress getEthernetAddress() {
        return this.address;
    }

    public void setRemoteAddress(@NotNull InetSocketAddress address) {
        this.address = address;
    }

    public boolean isConnected() {
        return this.channel.isOpen() && this.channel.isWritable();
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void close() {
        this.channel.close(this.channel.voidPromise());
    }

    public void setName(@NotNull String newName) {
        this.name = newName;
    }

    @NotNull
    public String getName() {
        return this.name == null ? "" : this.name;
    }
}

