/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.network.channel;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import systems.reformcloud.reformcloud2.executor.api.network.channel.NetworkChannel;
import systems.reformcloud.reformcloud2.executor.api.network.channel.manager.ChannelManager;
import systems.reformcloud.reformcloud2.executor.api.utility.list.Streams;
import systems.reformcloud.reformcloud2.shared.network.channel.DefaultNetworkChannel;

public class DefaultChannelManager
implements ChannelManager {
    private final Map<String, NetworkChannel> channels = new ConcurrentHashMap<String, NetworkChannel>();

    @NotNull
    public Optional<NetworkChannel> getChannel(@NotNull String name) {
        return Optional.ofNullable(this.channels.get(name));
    }

    @NotNull
    public @UnmodifiableView Collection<NetworkChannel> getNetworkChannels(@NotNull String remoteAddress) {
        return Streams.allOf(this.channels.values(), channel -> channel.getAddress().equals(remoteAddress));
    }

    @NotNull
    public Optional<NetworkChannel> getFirstChannel() {
        Iterator<NetworkChannel> iterator = this.channels.values().iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    @NotNull
    public @UnmodifiableView Collection<NetworkChannel> getRegisteredChannels() {
        return Collections.unmodifiableCollection(this.channels.values());
    }

    @NotNull
    public NetworkChannel createChannel(@NotNull Channel channel) {
        return new DefaultNetworkChannel(channel);
    }

    public void registerChannel(@NotNull NetworkChannel channel) {
        this.channels.put(channel.getName(), channel);
    }

    public void unregisterChannel(@NotNull String name) {
        this.channels.remove(name);
    }
}

