/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.base.Conditions;
import systems.reformcloud.reformcloud2.executor.api.builder.ProcessGroupBuilder;
import systems.reformcloud.reformcloud2.executor.api.groups.ProcessGroup;
import systems.reformcloud.reformcloud2.executor.api.groups.template.Template;
import systems.reformcloud.reformcloud2.executor.api.groups.utils.PlayerAccessConfiguration;
import systems.reformcloud.reformcloud2.executor.api.groups.utils.StartupConfiguration;

public abstract class DefaultProcessGroupBuilder
implements ProcessGroupBuilder {
    protected String name;
    protected boolean staticGroup = false;
    protected boolean lobby = false;
    protected boolean showId = true;
    protected List<Template> templates = new ArrayList<Template>();
    protected PlayerAccessConfiguration playerAccessConfiguration = PlayerAccessConfiguration.createDefault();
    protected StartupConfiguration startupConfiguration = StartupConfiguration.createDefault();

    @NotNull
    public ProcessGroupBuilder name(@NotNull String name) {
        this.name = name;
        return this;
    }

    @NotNull
    public ProcessGroupBuilder staticGroup(boolean staticGroup) {
        this.staticGroup = staticGroup;
        return this;
    }

    @NotNull
    public ProcessGroupBuilder lobby(boolean lobby) {
        this.lobby = lobby;
        return this;
    }

    @NotNull
    public ProcessGroupBuilder templates(Template ... templates) {
        this.templates = Arrays.asList(templates);
        return this;
    }

    @NotNull
    public ProcessGroupBuilder templates(@NotNull List<Template> templates) {
        this.templates = templates;
        return this;
    }

    @NotNull
    public ProcessGroupBuilder playerAccessConfig(@NotNull PlayerAccessConfiguration configuration) {
        this.playerAccessConfiguration = configuration;
        return this;
    }

    @NotNull
    public ProcessGroupBuilder startupConfiguration(@NotNull StartupConfiguration configuration) {
        this.startupConfiguration = configuration;
        return this;
    }

    @NotNull
    public ProcessGroupBuilder showId(boolean showId) {
        this.showId = showId;
        return this;
    }

    @NotNull
    public ProcessGroup createTemporary() {
        Conditions.nonNull((Object)this.name, (Object)"Unable to create process group without a name");
        return new ProcessGroup(this.name, this.showId, this.startupConfiguration, this.templates, this.playerAccessConfiguration, this.staticGroup, this.lobby);
    }
}

