/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.event.Event;
import systems.reformcloud.reformcloud2.executor.api.event.ListenerContainer;
import systems.reformcloud.reformcloud2.executor.api.event.priority.EventPriority;

public final class DefaultListenerContainer
implements ListenerContainer {
    private final Class<?> eventClassTarget;
    private final Object listenerInstance;
    private final Method method;
    private final EventPriority priority;

    DefaultListenerContainer(Class<?> eventClassTarget, Object listenerInstance, Method method, EventPriority priority) {
        this.eventClassTarget = eventClassTarget;
        this.listenerInstance = listenerInstance;
        this.method = method;
        this.priority = priority;
        this.method.setAccessible(true);
    }

    @NotNull
    public Object getListenerInstance() {
        return this.listenerInstance;
    }

    @NotNull
    public Class<?> getTargetEventClass() {
        return this.eventClassTarget;
    }

    @NotNull
    public EventPriority getPriority() {
        return this.priority;
    }

    public void call(@NotNull Event event) throws InvocationTargetException, IllegalAccessException {
        this.method.invoke(this.listenerInstance, event);
    }
}

