/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import systems.reformcloud.reformcloud2.executor.api.event.Event;
import systems.reformcloud.reformcloud2.executor.api.event.EventManager;
import systems.reformcloud.reformcloud2.executor.api.event.ListenerContainer;
import systems.reformcloud.reformcloud2.executor.api.event.handler.Listener;
import systems.reformcloud.reformcloud2.executor.api.task.Task;
import systems.reformcloud.reformcloud2.shared.event.DefaultListenerContainer;

public final class DefaultEventManager
implements EventManager {
    private static final Comparator<ListenerContainer> PRIORITY_COMPARATOR = (c1, c2) -> c1.getPriority().getPriority() > c2.getPriority().getPriority() ? 1 : -1;
    private final List<ListenerContainer> registeredListeners = new CopyOnWriteArrayList<ListenerContainer>();

    @Nullable
    public <T extends Event> T callEvent(@NotNull Class<? extends T> event) {
        try {
            return (T)this.callEvent((Event)event.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException exception) {
            System.err.println("Missing NoArgsConstructor in event class " + event.getName());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @NotNull
    public <T extends Event> T callEvent(@NotNull T event) {
        ArrayList<ListenerContainer> containers = new ArrayList<ListenerContainer>();
        for (ListenerContainer registeredListener : this.registeredListeners) {
            if (!registeredListener.getTargetEventClass().equals(event.getClass())) continue;
            containers.add(registeredListener);
        }
        containers.sort(PRIORITY_COMPARATOR);
        for (ListenerContainer registeredListener : containers) {
            try {
                registeredListener.call(event);
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                System.err.println("Exception posting event " + event.getClass().getName() + " to class " + registeredListener.getListenerInstance().getClass().getName());
                exception.printStackTrace();
            }
        }
        return event;
    }

    @NotNull
    public <T extends Event> Task<T> callEventAsync(@NotNull Class<? extends T> event) {
        return Task.supply(() -> this.callEvent((Event)event));
    }

    @NotNull
    public <T extends Event> Task<T> callEventAsync(@NotNull T event) {
        return Task.supply(() -> this.callEvent(event));
    }

    public void registerListener(@NotNull Object listener) {
        for (Method declaredMethod : listener.getClass().getDeclaredMethods()) {
            Listener annotation = declaredMethod.getAnnotation(Listener.class);
            if (annotation == null) continue;
            Class<?>[] parameters = declaredMethod.getParameterTypes();
            if (parameters.length != 1) {
                System.err.println("Unable to register listener method " + declaredMethod.getName() + "@" + listener.getClass().getName() + " because method has more or less than one parameter");
                continue;
            }
            if (!Event.class.isAssignableFrom(parameters[0])) {
                System.err.println("Unable to register listener method " + declaredMethod.getName() + "@" + listener.getClass().getName() + " because parameter type " + parameters[0].getName() + " is not assignable from " + Event.class.getName());
                continue;
            }
            DefaultListenerContainer container = new DefaultListenerContainer(parameters[0], listener, declaredMethod, annotation.priority());
            this.registeredListeners.add(container);
        }
    }

    public void registerListener(@NotNull Class<?> listener) {
        try {
            this.registerListener(listener.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException exception) {
            System.err.println("Missing NoArgsConstructor in listener class " + listener.getName());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    public void unregisterListener(@NotNull Object listener) {
        this.registeredListeners.removeIf(listenerContainer -> listenerContainer.getListenerInstance() == listener);
    }

    public void unregisterAll() {
        this.registeredListeners.clear();
    }

    @NotNull
    public @UnmodifiableView List<ListenerContainer> getListeners() {
        return Collections.unmodifiableList(this.registeredListeners);
    }
}

