/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.shared.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import systems.reformcloud.reformcloud2.executor.api.command.Command;
import systems.reformcloud.reformcloud2.executor.api.command.CommandContainer;
import systems.reformcloud.reformcloud2.executor.api.command.CommandManager;
import systems.reformcloud.reformcloud2.executor.api.command.CommandSender;
import systems.reformcloud.reformcloud2.executor.api.utility.list.Streams;
import systems.reformcloud.reformcloud2.shared.command.DefaultCommandContainer;

public class DefaultCommandManager
implements CommandManager {
    private final Collection<CommandContainer> commands = new CopyOnWriteArrayList<CommandContainer>();

    @NotNull
    public CommandManager registerCommand(@NotNull Command command, @NotNull String description, @NotNull List<String> aliases) {
        for (String alias : aliases) {
            Optional<CommandContainer> registeredCommand = this.getCommand(alias.toLowerCase());
            if (!registeredCommand.isPresent()) continue;
            throw new RuntimeException("Command " + registeredCommand.get().getCommand().getClass().getName() + " clashes with " + command.getClass().getName() + " because of alias '" + alias + "'");
        }
        this.commands.add(new DefaultCommandContainer(aliases, description, command));
        return this;
    }

    public void unregisterCommand(@NotNull CommandContainer command) {
        this.commands.removeIf(commandContainer -> {
            for (String alias : commandContainer.getAliases()) {
                if (!command.getAliases().stream().anyMatch(alias::equals)) continue;
                return true;
            }
            return false;
        });
    }

    public void unregisterCommand(String ... aliases) {
        List toUnregister = Streams.toLowerCase(Arrays.asList(aliases));
        this.commands.removeIf(command -> Streams.hasMatch((Collection)command.getAliases(), toUnregister::contains));
    }

    @NotNull
    public Optional<CommandContainer> getCommand(@NotNull String anyAlias) {
        for (CommandContainer command : this.commands) {
            if (!command.getAliases().contains(anyAlias.toLowerCase())) continue;
            return Optional.of(command);
        }
        return Optional.empty();
    }

    @NotNull
    public @UnmodifiableView Collection<CommandContainer> getCommands() {
        return Collections.unmodifiableCollection(this.commands);
    }

    public boolean process(@NotNull String commandLine, @NotNull CommandSender commandSender) {
        String[] split = commandLine.split(" ");
        CommandContainer command = this.getCommand(commandSender, split);
        if (command == null) {
            return false;
        }
        CharSequence[] args = split.length > 1 ? Arrays.copyOfRange(split, 1, split.length) : new String[]{};
        try {
            command.getCommand().process(commandSender, (String[])args, commandLine);
        }
        catch (Throwable throwable) {
            System.err.println("Exception handling command \"" + split[0] + "\" with arguments " + String.join((CharSequence)", ", args));
            throwable.printStackTrace();
        }
        return true;
    }

    @NotNull
    public List<String> suggest(@NotNull String commandLine, @NotNull CommandSender commandSender) {
        String[] split = commandLine.split(" ");
        CommandContainer command = this.getCommand(commandSender, split);
        if (command == null) {
            return new ArrayList<String>();
        }
        int argumentIndex = commandLine.length() - commandLine.replace(" ", "").length() - 1;
        CharSequence[] args = split.length > 1 ? Arrays.copyOfRange(split, 1, split.length) : new String[]{};
        try {
            return command.getCommand().suggest(commandSender, (String[])args, argumentIndex, commandLine);
        }
        catch (Throwable throwable) {
            System.err.println("Exception tab completing command \"" + split[0] + "\" with arguments " + String.join((CharSequence)", ", args));
            throwable.printStackTrace();
            return new ArrayList<String>();
        }
    }

    @Nullable
    private CommandContainer getCommand(@NotNull CommandSender commandSender, @NotNull String[] split) {
        if (split.length == 0) {
            return null;
        }
        Optional<CommandContainer> command = this.getCommand(split[0]);
        return command.filter(commandContainer -> commandContainer.getCommand().canAccess(commandSender)).orElse(null);
    }
}

