/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.tab.listener;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.api.API;
import systems.reformcloud.reformcloud2.executor.api.common.event.handler.Listener;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.events.group.PermissionGroupUpdateEvent;
import systems.reformcloud.reformcloud2.permissions.events.user.PermissionUserUpdateEvent;
import systems.reformcloud.reformcloud2.tab.ReformCloudTabPlugin;

public class CloudTabListeners {
    private final Plugin plugin;

    public CloudTabListeners(Plugin plugin) {
        this.plugin = plugin;
    }

    @Listener
    public void handle(@NotNull PermissionUserUpdateEvent event) {
        if (API.getInstance().getCurrentProcessInformation().getExtra().getBoolean("disable-tab").booleanValue()) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)event.getPermissionUser().getUniqueID());
        if (player == null) {
            return;
        }
        Bukkit.getScheduler().runTask(this.plugin, () -> ReformCloudTabPlugin.pullPlayerNameTags(player));
    }

    @Listener
    public void handle(@NotNull PermissionGroupUpdateEvent event) {
        if (API.getInstance().getCurrentProcessInformation().getExtra().getBoolean("disable-tab").booleanValue()) {
            return;
        }
        Bukkit.getScheduler().runTask(this.plugin, () -> Bukkit.getOnlinePlayers().forEach(player -> {
            if (PermissionManagement.getInstance().loadUser(player.getUniqueId()).isInGroup(event.getPermissionGroup().getName())) {
                ReformCloudTabPlugin.pullPlayerNameTags(player);
            }
        }));
    }
}

