/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.tab;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.base.Conditions;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;
import systems.reformcloud.reformcloud2.tab.listener.BukkitTabListeners;
import systems.reformcloud.reformcloud2.tab.listener.CloudTabListeners;

public class ReformCloudTabPlugin
extends JavaPlugin {
    private static Method setColor;

    public void onEnable() {
        if (Bukkit.getPluginManager().getPlugin("ReformCloud2BukkitPermissions") == null) {
            System.err.println("[Tab] Unable to find permission plugin, do not load permission listeners");
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitTabListeners(), (Plugin)this);
        ExecutorAPI.getInstance().getEventManager().registerListener((Object)new CloudTabListeners((Plugin)this));
    }

    public static void pullPlayerNameTags(@NotNull Player player) {
        Conditions.isTrue((boolean)Bukkit.isPrimaryThread(), (Object)"Can only update the tab teams from the main thread");
        if (Bukkit.getScoreboardManager() == null) {
            return;
        }
        if (player.getScoreboard().equals(Bukkit.getScoreboardManager().getMainScoreboard())) {
            player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        }
        PermissionUser permissionUser = ReformCloudTabPlugin.getUser(player.getUniqueId());
        Bukkit.getOnlinePlayers().forEach(onlinePlayer -> {
            PermissionUser onlinePermissionUser;
            if (onlinePlayer.getScoreboard().equals(Bukkit.getScoreboardManager().getMainScoreboard())) {
                onlinePlayer.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
            }
            if (permissionUser != null) {
                ReformCloudTabPlugin.registerPlayerTeam(player, onlinePlayer, permissionUser);
            }
            if ((onlinePermissionUser = ReformCloudTabPlugin.getUser(onlinePlayer.getUniqueId())) != null) {
                ReformCloudTabPlugin.registerPlayerTeam(onlinePlayer, player, onlinePermissionUser);
            }
        });
    }

    @Nullable
    private static PermissionUser getUser(@NotNull UUID uniqueID) {
        return PermissionManagement.getInstance().getExistingUser(uniqueID).orElse(null);
    }

    private static void registerPlayerTeam(@NotNull Player player, @NotNull Player other, @NotNull PermissionUser permissionUser) {
        String suffix;
        String prefix;
        Team team;
        int priority = 0;
        String teamName = player.getName();
        PermissionGroup permissionGroup = permissionUser.getHighestPermissionGroup().orElse(null);
        if (permissionGroup != null) {
            priority = permissionGroup.getPriority();
        }
        if ((teamName = priority + teamName).length() > 16) {
            teamName = teamName.substring(0, 16);
        }
        if ((team = other.getScoreboard().getTeam(teamName)) == null) {
            team = other.getScoreboard().registerNewTeam(teamName);
        }
        if (setColor != null) {
            try {
                ChatColor chatColor;
                String color = permissionUser.getColour().orElse(null);
                if (color != null && !color.isEmpty()) {
                    chatColor = ChatColor.getByChar((String)color.replace("&", "").replace("\u00a7", ""));
                    if (chatColor != null) {
                        setColor.invoke((Object)team, chatColor);
                    }
                } else if (permissionUser.getPrefix().isPresent() && !(color = ChatColor.getLastColors((String)((String)permissionUser.getPrefix().get()))).isEmpty() && (chatColor = ChatColor.getByChar((String)color.replace("&", "").replace("\u00a7", ""))) != null) {
                    setColor.invoke((Object)team, chatColor);
                }
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
        if ((prefix = (String)permissionUser.getPrefix().orElse(null)) != null) {
            prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)prefix);
            if (setColor != null && prefix.length() > 64) {
                prefix = prefix.substring(0, 64);
            } else if (setColor == null && prefix.length() > 16) {
                prefix = prefix.substring(0, 16);
            }
            team.setPrefix(prefix);
        }
        if ((suffix = (String)permissionUser.getSuffix().orElse(null)) != null) {
            suffix = ChatColor.translateAlternateColorCodes((char)'&', (String)suffix);
            if (setColor != null && suffix.length() > 64) {
                suffix = suffix.substring(0, 64);
            } else if (setColor == null && suffix.length() > 16) {
                suffix = suffix.substring(0, 16);
            }
            team.setSuffix(suffix);
        }
        team.addEntry(player.getName());
        player.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)(permissionUser.getDisplay().orElse("") + player.getName())));
    }

    static {
        try {
            setColor = Team.class.getDeclaredMethod("setColor", ChatColor.class);
            setColor.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

