/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reforncloud2.notifications.velocity.listener;

import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.text.Component;
import net.kyori.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.api.basic.events.ProcessStartedEvent;
import systems.reformcloud.reformcloud2.executor.api.common.api.basic.events.ProcessStoppedEvent;
import systems.reformcloud.reformcloud2.executor.api.common.api.basic.events.ProcessUpdatedEvent;
import systems.reformcloud.reformcloud2.executor.api.common.event.handler.Listener;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.manager.DefaultChannelManager;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.common.utility.task.Task;
import systems.reformcloud.reformcloud2.executor.api.common.utility.thread.AbsoluteThread;
import systems.reformcloud.reformcloud2.executor.api.velocity.VelocityExecutor;

public final class ProcessListener {
    private static final Map<UUID, ProcessInformation> REGISTERED = new ConcurrentHashMap<UUID, ProcessInformation>();
    private final ProxyServer proxyServer;

    public ProcessListener(@NotNull ProxyServer server) {
        Task.EXECUTOR.execute(() -> {
            while (DefaultChannelManager.INSTANCE.get("Controller").isEmpty()) {
                AbsoluteThread.sleep((long)50L);
            }
            ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getAllProcesses().forEach(e -> REGISTERED.put(e.getProcessDetail().getProcessUniqueID(), (ProcessInformation)e));
        });
        this.proxyServer = server;
    }

    @Listener
    public void handle(ProcessStartedEvent event) {
        this.publishNotification(VelocityExecutor.getInstance().getMessages().getProcessStarted(), event.getProcessInformation().getProcessDetail().getName());
    }

    @Listener
    public void handle(ProcessStoppedEvent event) {
        if (!REGISTERED.containsKey(event.getProcessInformation().getProcessDetail().getProcessUniqueID())) {
            return;
        }
        this.publishNotification(VelocityExecutor.getInstance().getMessages().getProcessStopped(), event.getProcessInformation().getProcessDetail().getName());
        REGISTERED.remove(event.getProcessInformation().getProcessDetail().getProcessUniqueID());
    }

    @Listener
    public void handle(ProcessUpdatedEvent event) {
        ProcessInformation old = REGISTERED.put(event.getProcessInformation().getProcessDetail().getProcessUniqueID(), event.getProcessInformation());
        if (old != null) {
            if (!old.getNetworkInfo().isConnected() && event.getProcessInformation().getNetworkInfo().isConnected()) {
                this.publishNotification(VelocityExecutor.getInstance().getMessages().getProcessConnected(), event.getProcessInformation().getProcessDetail().getName());
            }
            return;
        }
        this.publishNotification(VelocityExecutor.getInstance().getMessages().getProcessRegistered(), event.getProcessInformation().getProcessDetail().getName());
    }

    private void publishNotification(String message, Object ... replacements) {
        String replacedMessage = VelocityExecutor.getInstance().getMessages().format(message, replacements);
        this.proxyServer.getAllPlayers().stream().filter(e -> e.hasPermission("reformcloud.notify")).forEach(player -> player.sendMessage((Component)LegacyComponentSerializer.legacyLinking().deserialize(replacedMessage)));
    }
}

