/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.web.tokens;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.common.configuration.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.common.restapi.auth.Auth;
import systems.reformcloud.reformcloud2.executor.api.common.restapi.request.WebRequester;
import systems.reformcloud.reformcloud2.executor.api.common.restapi.request.defaults.DefaultWebRequester;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Duo;
import systems.reformcloud.reformcloud2.web.WebApplication;
import systems.reformcloud.reformcloud2.web.tokens.SetupWebRequester;
import systems.reformcloud.reformcloud2.web.tokens.TokenDatabase;

public class TokenWebServerAuth
implements Auth {
    private final Map<Long, WebRequester> handled = new ConcurrentHashMap<Long, WebRequester>();

    @NotNull
    public Duo<Boolean, WebRequester> handleAuth(@NotNull JsonConfiguration configurable, @NotNull ChannelHandlerContext channelHandlerContext) {
        String token = configurable.getOrDefault("token", (String)null);
        if (token == null) {
            if (TokenDatabase.isSetupDone()) {
                return new Duo((Object)false, null);
            }
            long current = System.currentTimeMillis();
            if (!WebApplication.WEB_COMMAND.tryAwait(current, this, (WebRequester)new SetupWebRequester(channelHandlerContext, "rc_setup"))) {
                System.err.println("Another setup is already running");
                return new Duo((Object)false, null);
            }
            System.out.println("Please verify that you've send the request to setup the web portal by typing \"web verify\"... (Request times out in 15 sec)");
            while (!this.handled.containsKey(current) && current + TimeUnit.SECONDS.toMillis(15L) > System.currentTimeMillis()) {
            }
            WebRequester requester = this.handled.remove(current);
            return new Duo((Object)(requester != null ? 1 : 0), (Object)requester);
        }
        if (TokenDatabase.tryAuth(token)) {
            DefaultWebRequester webRequester = new DefaultWebRequester(channelHandlerContext, "reformcloud_internal", Collections.singletonList("*"));
            return new Duo((Object)true, (Object)webRequester);
        }
        return new Duo((Object)false, null);
    }

    public void complete(long time, WebRequester result) {
        if (time + TimeUnit.SECONDS.toMillis(15L) <= System.currentTimeMillis()) {
            return;
        }
        this.handled.put(time, result);
    }
}

