/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.backends.url;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.common.configuration.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.common.groups.ProcessGroup;
import systems.reformcloud.reformcloud2.executor.api.common.groups.template.backend.TemplateBackend;
import systems.reformcloud.reformcloud2.executor.api.common.groups.template.backend.TemplateBackendManager;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Streams;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.DownloadHelper;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.SystemHelper;
import systems.reformcloud.reformcloud2.executor.api.common.utility.task.Task;

public final class URLTemplateBackend
implements TemplateBackend {
    private final String basePath;

    private URLTemplateBackend(JsonConfiguration configuration) {
        this.basePath = configuration.getString("baseUrl");
    }

    public static void load(String basePath) {
        if (!Files.exists(Paths.get(basePath + "/url.json", new String[0]), new LinkOption[0])) {
            new JsonConfiguration().add("baseUrl", "https://127.0.0.1/rc/templates").write(Paths.get(basePath + "/url.json", new String[0]));
        }
        TemplateBackendManager.registerBackend((TemplateBackend)new URLTemplateBackend(JsonConfiguration.read((Path)Paths.get(basePath + "/url.json", new String[0]))));
    }

    public static void unload() {
        TemplateBackendManager.unregisterBackend((String)"URL");
    }

    public boolean existsTemplate(@NotNull String group, @NotNull String template) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(this.getBasePath() + group + "-" + template + ".zip").openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            connection.setUseCaches(false);
            connection.connect();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void createTemplate(@NotNull String group, @NotNull String template) {
    }

    @NotNull
    public Task<Void> loadTemplate(@NotNull String group, @NotNull String template, @NotNull Path target) {
        DownloadHelper.downloadAndDisconnect((String)(this.getBasePath() + group + "-" + template + ".zip"), (String)"reformcloud/files/temp/template.zip");
        SystemHelper.unZip((File)new File("reformcloud/files/temp/template.zip"), (String)target.toString());
        SystemHelper.deleteFile((File)new File("reformcloud/files/temp/template.zip"));
        return Task.completedTask(null);
    }

    @NotNull
    public Task<Void> loadGlobalTemplates(@NotNull ProcessGroup group, @NotNull Path target) {
        Streams.allOf((Collection)group.getTemplates(), e -> e.getBackend().equals(this.getName()) && e.isGlobal()).forEach(e -> this.loadTemplate(group.getName(), e.getName(), target));
        return Task.completedTask(null);
    }

    @NotNull
    public Task<Void> loadPath(@NotNull String path, @NotNull Path target) {
        DownloadHelper.downloadAndDisconnect((String)(this.getBasePath() + path), (String)"reformcloud/files/temp/template.zip");
        SystemHelper.unZip((File)new File("reformcloud/files/temp/template.zip"), (String)target.toString());
        SystemHelper.deleteFile((File)new File("reformcloud/files/temp/template.zip"));
        return Task.completedTask(null);
    }

    public void deployTemplate(@NotNull String group, @NotNull String template, @NotNull Path current, @NotNull Collection<String> collection) {
    }

    public void deleteTemplate(@NotNull String group, @NotNull String template) {
    }

    private String getBasePath() {
        return this.basePath.endsWith("/") ? this.basePath : this.basePath + "/";
    }

    @NotNull
    public String getName() {
        return "URL";
    }
}

