/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.backends.sftp;

import com.google.gson.reflect.TypeToken;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.backends.sftp.SFTPConfig;
import systems.reformcloud.reformcloud2.executor.api.common.configuration.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.common.groups.ProcessGroup;
import systems.reformcloud.reformcloud2.executor.api.common.groups.template.backend.TemplateBackend;
import systems.reformcloud.reformcloud2.executor.api.common.groups.template.backend.TemplateBackendManager;
import systems.reformcloud.reformcloud2.executor.api.common.network.NetworkUtil;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Streams;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.SystemHelper;
import systems.reformcloud.reformcloud2.executor.api.common.utility.task.Task;
import systems.reformcloud.reformcloud2.executor.api.common.utility.task.defaults.DefaultTask;

public final class SFTPTemplateBackend
implements TemplateBackend {
    private static final BlockingDeque<Runnable> TASKS = new LinkedBlockingDeque<Runnable>();
    private final SFTPConfig config;
    private Session session;
    private ChannelSftp channel;

    private SFTPTemplateBackend(SFTPConfig config) {
        this.config = config;
        this.open();
        NetworkUtil.EXECUTOR.execute(() -> {
            while (!Thread.interrupted()) {
                try {
                    boolean available;
                    Runnable runnable = TASKS.poll(20L, TimeUnit.SECONDS);
                    boolean bl = available = !this.isDisconnected();
                    if (runnable == null) {
                        if (!available) continue;
                        this.channel.disconnect();
                        continue;
                    }
                    if (!available) {
                        this.open();
                    }
                    runnable.run();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public static void load(String baseDirectory) {
        SFTPConfig config;
        if (Files.notExists(Paths.get(baseDirectory, "sftp.json"), new LinkOption[0])) {
            new JsonConfiguration().add("config", (Object)new SFTPConfig(false, "127.0.0.1", 22, "rc", "password", "/home/templates/")).write(Paths.get(baseDirectory, "sftp.json"));
        }
        if ((config = (SFTPConfig)JsonConfiguration.read((Path)Paths.get(baseDirectory, "sftp.json")).get("config", (TypeToken)new TypeToken<SFTPConfig>(){})) == null || !config.isEnabled()) {
            return;
        }
        TemplateBackendManager.registerBackend((TemplateBackend)new SFTPTemplateBackend(config));
    }

    public static void unload() {
        TemplateBackendManager.unregisterBackend((String)"SFTP");
    }

    private static Task<Void> future(@NotNull Runnable runnable) {
        DefaultTask completableFuture = new DefaultTask();
        Runnable newRunnable = () -> SFTPTemplateBackend.lambda$future$1(runnable, (Task)completableFuture);
        TASKS.offerLast(newRunnable);
        return completableFuture;
    }

    private boolean isDisconnected() {
        return this.session == null || !this.session.isConnected() || this.channel == null || !this.channel.isConnected();
    }

    public boolean existsTemplate(@NotNull String group, @NotNull String template) {
        if (this.isDisconnected()) {
            return false;
        }
        try {
            SftpATTRS attrs = this.channel.stat(this.config.getBaseDirectory() + group + "/" + template);
            return attrs != null && attrs.isDir();
        }
        catch (SftpException ex) {
            return false;
        }
    }

    public void createTemplate(@NotNull String group, @NotNull String template) {
        if (this.isDisconnected()) {
            return;
        }
        SFTPTemplateBackend.future(() -> this.makeDirectory(this.config.getBaseDirectory() + group + "/" + template));
    }

    @NotNull
    public Task<Void> loadTemplate(@NotNull String group, @NotNull String template, @NotNull Path target) {
        if (this.isDisconnected()) {
            return Task.completedTask(null);
        }
        return SFTPTemplateBackend.future(() -> this.downloadDirectory(this.config.getBaseDirectory() + group + "/" + template, target.toString()));
    }

    public void downloadDirectory(String remotePath, String localPath) {
        try {
            Collection<ChannelSftp.LsEntry> entries = this.listFiles(remotePath);
            if (entries == null) {
                return;
            }
            Path dir = Paths.get(localPath, new String[0]);
            SystemHelper.recreateDirectory((Path)dir);
            if (!localPath.endsWith("/")) {
                localPath = localPath + "/";
            }
            if (!remotePath.endsWith("/")) {
                remotePath = remotePath + "/";
            }
            for (ChannelSftp.LsEntry entry : entries) {
                if (entry.getAttrs().isDir()) {
                    this.downloadDirectory(remotePath + entry.getFilename(), localPath + entry.getFilename());
                    continue;
                }
                OutputStream outputStream = Files.newOutputStream(Paths.get(localPath, entry.getFilename()), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    this.channel.get(remotePath + entry.getFilename(), outputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
        }
        catch (SftpException | IOException ex) {
            ex.printStackTrace();
        }
    }

    @NotNull
    public Task<Void> loadGlobalTemplates(@NotNull ProcessGroup group, @NotNull Path target) {
        return SFTPTemplateBackend.future(() -> Streams.allOf((Collection)group.getTemplates(), e -> e.getBackend().equals(this.getName()) && e.isGlobal()).forEach(e -> this.loadTemplate(group.getName(), e.getName(), target)));
    }

    @NotNull
    public Task<Void> loadPath(@NotNull String path, @NotNull Path target) {
        if (this.isDisconnected()) {
            return Task.completedTask(null);
        }
        return SFTPTemplateBackend.future(() -> this.downloadDirectory(this.config.getBaseDirectory() + path, target.toString()));
    }

    public void deployTemplate(@NotNull String group, @NotNull String template, @NotNull Path current, @NotNull Collection<String> collection) {
        if (this.isDisconnected()) {
            return;
        }
        SFTPTemplateBackend.future(() -> {
            try {
                File[] files = current.toFile().listFiles((File e) -> {
                    String full = e.getAbsolutePath().replaceFirst(current.toFile().getAbsolutePath(), "").replaceFirst("\\\\", "");
                    return !collection.contains(full);
                });
                if (files == null || files.length == 0) {
                    return;
                }
                this.makeDirectory(this.config.getBaseDirectory() + group + "/" + template);
                for (File file : files) {
                    this.upload(this.config.getBaseDirectory() + group + "/" + template, file);
                }
            }
            catch (SftpException ex) {
                ex.printStackTrace();
            }
        });
    }

    private void upload(String path, File file) throws SftpException {
        String currentPath = path + "/" + file.getName();
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                return;
            }
            this.makeDirectory(currentPath);
            for (File next : files) {
                this.upload(currentPath, next);
            }
        } else if (file.isFile()) {
            this.channel.put(file.getPath(), currentPath);
        }
    }

    public void deleteTemplate(@NotNull String group, @NotNull String template) {
        if (this.isDisconnected()) {
            return;
        }
        this.deleteAll(this.config.getBaseDirectory() + group + "/" + template);
    }

    private void deleteAll(String path) {
        try {
            Collection<ChannelSftp.LsEntry> entries = this.listFiles(path);
            if (entries == null) {
                return;
            }
            for (ChannelSftp.LsEntry entry : entries) {
                if (entry.getAttrs().isDir()) {
                    this.deleteAll(path + "/" + entry.getFilename());
                    continue;
                }
                this.channel.rm(path + "/" + entry.getFilename());
            }
            this.channel.rmdir(path);
        }
        catch (SftpException ex) {
            ex.printStackTrace();
        }
    }

    private void makeDirectory(String path) {
        StringBuilder builder = new StringBuilder();
        for (String pathSegment : path.split("/")) {
            builder.append('/').append(pathSegment);
            try {
                this.channel.mkdir(builder.toString());
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
        }
        this.goToBase();
    }

    private void goToBase() {
        try {
            this.channel.cd(this.config.getBaseDirectory().startsWith("/") ? this.config.getBaseDirectory() : "/" + this.config.getBaseDirectory());
        }
        catch (SftpException ex) {
            ex.printStackTrace();
        }
    }

    public Collection<ChannelSftp.LsEntry> listFiles(String directory) {
        ArrayList<ChannelSftp.LsEntry> entries = new ArrayList<ChannelSftp.LsEntry>();
        try {
            this.channel.ls(directory, lsEntry -> {
                if (!lsEntry.getFilename().equals("..") && !lsEntry.getFilename().equals(".")) {
                    entries.add(lsEntry);
                }
                return 0;
            });
        }
        catch (SftpException ex) {
            return null;
        }
        return entries;
    }

    private void open() {
        try {
            this.session = new JSch().getSession(this.config.getUser(), this.config.getHost(), this.config.getPort());
            this.session.setPassword(this.config.getPassword());
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect(2500);
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            if (this.channel == null) {
                this.session.disconnect();
                this.session = null;
                return;
            }
            this.channel.connect();
            this.channel.setFilenameEncoding(StandardCharsets.UTF_8.name());
        }
        catch (JSchException | SftpException ex) {
            ex.printStackTrace();
        }
    }

    @NotNull
    public String getName() {
        return "SFTP";
    }

    private static /* synthetic */ void lambda$future$1(Runnable runnable, Task completableFuture) {
        runnable.run();
        completableFuture.complete(null);
    }
}

